/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import com.jfoenix.controls.JFXToggleButton;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import tarski.core.controller.WorldController;

public class WorldPassToggle
extends HBox {
    private Label yesLabel;
    private Label noLabel;
    private Label worldShouldPassLabel;
    private JFXToggleButton worldShouldPassBtn;
    private WorldController worldController;

    public WorldPassToggle(WorldController worldController) {
        this.worldController = worldController;
        this.setAlignment(Pos.CENTER_RIGHT);
        this.worldShouldPassLabel = new Label("Formula is");
        this.worldShouldPassLabel.setPadding(new Insets(0.0, 15.0, 0.0, 0.0));
        this.yesLabel = new Label("True");
        this.yesLabel.getStyleClass().add("custom-label-disactivated");
        this.noLabel = new Label("False");
        this.noLabel.getStyleClass().add("custom-label-disactivated");
        this.worldShouldPassBtn = new JFXToggleButton();
        this.worldShouldPassBtn.setTextAlignment(TextAlignment.LEFT);
        this.worldShouldPassBtn.getStyleClass().add("custom-jfx-toggle-button");
        this.worldShouldPassBtn.setSelected(worldController.getWorldShouldPass());
        this.worldShouldPassBtn.selectedProperty().addListener((observable, oldVal, newVal) -> this.isToggledAction());
        this.isToggledAction();
        this.getChildren().addAll((Node[])new Node[]{this.worldShouldPassLabel, this.noLabel, this.worldShouldPassBtn, this.yesLabel});
    }

    private void isToggledAction() {
        if (this.worldShouldPassBtn.isSelected()) {
            this.changeToToggled();
            this.worldShouldPassBtn.setSelected(true);
        } else {
            this.changeToUntoggled();
            this.worldShouldPassBtn.setSelected(false);
        }
    }

    public void resizeToNewMaxWidth(double newWidth) {
        double fontSize = newWidth * 10.0 / 400.0;
        this.worldShouldPassLabel.setStyle("-fx-font-size:" + fontSize + "!important;");
        this.yesLabel.setStyle("-fx-font-size:" + fontSize + "!important;");
        this.noLabel.setStyle("-fx-font-size:" + fontSize + "!important;");
        this.setMaxWidth(newWidth);
    }

    private void changeToToggled() {
        this.worldController.setWorldShouldPass(true);
        this.yesLabel.getStyleClass().clear();
        this.yesLabel.getStyleClass().add("custom-yes-label-activated");
        this.noLabel.getStyleClass().clear();
        this.noLabel.getStyleClass().add("custom-label-disactivated");
    }

    private void changeToUntoggled() {
        this.worldController.setWorldShouldPass(false);
        this.yesLabel.getStyleClass().clear();
        this.yesLabel.getStyleClass().add("custom-label-disactivated");
        this.noLabel.getStyleClass().clear();
        this.noLabel.getStyleClass().add("custom-no-label-activated");
    }
}

