/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import java.util.Stack;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import tarski.core.controller.WorldController;
import tarski.gui.world.WorldEditTips;
import tarski.gui.world.WorldPassToggle;

public class WorldInfoBar
extends AnchorPane {
    private Label label = new Label();
    private Stack<WorldEditTips> tipStack;

    public WorldInfoBar(WorldController worldController) {
        this.label.getStyleClass().add("world-tip-bar-text");
        WorldInfoBar.setTopAnchor(this.label, 0.0);
        WorldInfoBar.setBottomAnchor(this.label, 0.0);
        WorldInfoBar.setLeftAnchor(this.label, 0.0);
        this.getStyleClass().add("world-tip-bar");
        WorldPassToggle worldPassToggle = new WorldPassToggle(worldController);
        WorldInfoBar.setTopAnchor(worldPassToggle, 0.0);
        WorldInfoBar.setBottomAnchor(worldPassToggle, 0.0);
        WorldInfoBar.setRightAnchor(worldPassToggle, 0.0);
        this.getChildren().addAll((Node[])new Node[]{this.label, worldPassToggle});
        this.tipStack = new Stack();
        this.stackInfoTip(WorldEditTips.DEFAULT);
        this.widthProperty().addListener((observable, oldVal, newVal) -> {
            this.label.setMaxWidth(newVal.doubleValue() / 2.0);
            double fontSize = newVal.doubleValue() * 8.5 / 400.0;
            this.label.setStyle("-fx-font-size:" + fontSize + "!important;");
            worldPassToggle.resizeToNewMaxWidth(newVal.doubleValue());
        });
    }

    public void stackInfoTip(WorldEditTips tip) {
        this.tipStack.push(tip);
        this.label.setText(this.tipStack.peek().getTip());
    }

    public void PopTopTip() {
        if (this.tipStack.size() > 1) {
            this.tipStack.pop();
            this.label.setText(this.tipStack.peek().getTip());
        }
    }
}

