/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import java.util.ArrayList;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import tarski.core.block.BlockSize;
import tarski.core.block.BlockType;
import tarski.gui.world.ShapeToggleButton;
import tarski.gui.world.UIWorld;

public class WorldEditor
extends VBox {
    private static final double MIN_BUTTON_SIZE = 15.0;
    private ToggleGroup toggleButtonGroup;
    private ArrayList<Label> labels = new ArrayList();
    private SimpleDoubleProperty smallSize = new SimpleDoubleProperty();
    private SimpleDoubleProperty mediumSize = new SimpleDoubleProperty();
    private SimpleDoubleProperty largeSize = new SimpleDoubleProperty();
    private SimpleDoubleProperty buttonSize = new SimpleDoubleProperty();

    public WorldEditor() {
        this.getStyleClass().add("world-editor");
        this.setAlignment(Pos.CENTER);
        this.toggleButtonGroup = new ToggleGroup();
        this.getChildren().add(this.createSpacer());
        for (BlockSize blockSize : BlockSize.values()) {
            this.getChildren().addAll((Node[])new Node[]{this.createButtonTriplet(blockSize)});
        }
        this.getChildren().add(this.createSpacer());
    }

    private VBox createButtonTriplet(BlockSize blockSize) {
        VBox sizeVbox = new VBox();
        this.updateOnResize();
        this.configureTripletVbox(sizeVbox, blockSize);
        for (BlockType blockType : BlockType.values()) {
            ToggleButton toggleButton = this.configureNewButton(blockSize, blockType);
            toggleButton.getStyleClass().add("custom-toggle-button");
            toggleButton.setToggleGroup(this.toggleButtonGroup);
            sizeVbox.getChildren().addAll((Node[])new Node[]{toggleButton, this.createSpacer()});
        }
        UIWorld.TILE_SIZE.addListener((ChangeListener<? super Number>)((ChangeListener<Number>)(observable, oldVal, newVal) -> this.updateOnResize()));
        return sizeVbox;
    }

    private VBox configureTripletVbox(VBox sizeVbox, BlockSize blockSize) {
        Label sizeLabel = new Label();
        sizeVbox.setAlignment(Pos.CENTER);
        sizeVbox.getChildren().add(this.createSpacer());
        switch (blockSize) {
            case SMALL: {
                sizeLabel.setText("Small");
                break;
            }
            case MEDIUM: {
                sizeVbox.getStyleClass().add("world-editor-sub-menu");
                sizeLabel.setText("Medium");
                Region firstSpacer = this.createSpacer();
                Region secondSpacer = this.createSpacer();
                secondSpacer.getStyleClass().add("world-editor-sub-menu");
                this.getChildren().addAll((Node[])new Node[]{firstSpacer, secondSpacer});
                break;
            }
            case LARGE: {
                sizeLabel.setText("Large");
                Region thirdSpacer = this.createSpacer();
                Region fourthSpacer = this.createSpacer();
                thirdSpacer.getStyleClass().add("world-editor-sub-menu");
                this.getChildren().addAll((Node[])new Node[]{thirdSpacer, fourthSpacer});
            }
        }
        sizeLabel.getStyleClass().add("world-editor-size-label");
        sizeVbox.getChildren().add(sizeLabel);
        this.labels.add(sizeLabel);
        return sizeVbox;
    }

    private ToggleButton configureNewButton(BlockSize blockSize, BlockType blockType) {
        ShapeToggleButton newToggleBtn = new ShapeToggleButton();
        Region shapeRegion = new Region();
        switch (blockSize) {
            case SMALL: {
                shapeRegion.getStyleClass().add("shape-color-small");
                newToggleBtn.setBlockSize(BlockSize.SMALL);
                this.bindRegionToSize(shapeRegion, this.smallSize);
                break;
            }
            case MEDIUM: {
                shapeRegion.getStyleClass().add("shape-color-medium");
                newToggleBtn.setBlockSize(BlockSize.MEDIUM);
                this.bindRegionToSize(shapeRegion, this.mediumSize);
                break;
            }
            case LARGE: {
                shapeRegion.getStyleClass().add("shape-color-large");
                newToggleBtn.setBlockSize(BlockSize.LARGE);
                this.bindRegionToSize(shapeRegion, this.largeSize);
            }
        }
        switch (blockType) {
            case SQUARE: {
                shapeRegion.getStyleClass().add("shape-square");
                newToggleBtn.setBlockType(BlockType.SQUARE);
                break;
            }
            case TRIANGLE: {
                shapeRegion.getStyleClass().add("shape-triangle");
                newToggleBtn.setBlockType(BlockType.TRIANGLE);
                break;
            }
            case PENTAGON: {
                shapeRegion.getStyleClass().add("shape-pentagon");
                newToggleBtn.setBlockType(BlockType.PENTAGON);
            }
        }
        StackPane buttonPane = new StackPane();
        this.bindRegionToSize(buttonPane, this.buttonSize);
        buttonPane.getChildren().add(shapeRegion);
        newToggleBtn.setGraphic(buttonPane);
        return newToggleBtn;
    }

    public void updateOnResize() {
        double tileToButtonSizeRation = 0.9;
        double newSmallSize = this.getValueWithMinimumFloor(UIWorld.TILE_SIZE.getValue() * tileToButtonSizeRation - 35.0);
        double newMediumSize = this.getValueWithMinimumFloor(UIWorld.TILE_SIZE.getValue() * tileToButtonSizeRation - 20.0);
        double newLargeSize = this.getValueWithMinimumFloor(UIWorld.TILE_SIZE.getValue() * tileToButtonSizeRation - 5.0);
        double newButtonSize = this.getValueWithMinimumFloor(UIWorld.TILE_SIZE.getValue() * tileToButtonSizeRation - 10.0);
        this.smallSize.setValue(newSmallSize);
        this.mediumSize.setValue(newMediumSize);
        this.largeSize.setValue(newLargeSize);
        this.buttonSize.setValue(newButtonSize);
        double newFontSize = UIWorld.TILE_SIZE.getValue() * 10.0 / 50.0;
        for (Label label : this.labels) {
            label.setStyle("-fx-font-size:" + newFontSize + "!important;");
        }
    }

    public double getValueWithMinimumFloor(double val) {
        if (val < 15.0) {
            return 15.0;
        }
        return val;
    }

    public void bindRegionToSize(Region region, SimpleDoubleProperty size) {
        region.prefHeightProperty().bind(size);
        region.prefWidthProperty().bind(size);
        region.minHeightProperty().bind(size);
        region.minWidthProperty().bind(size);
        region.maxHeightProperty().bind(size);
        region.maxWidthProperty().bind(size);
    }

    private Region createSpacer() {
        Region spacer = new Region();
        VBox.setVgrow(spacer, Priority.ALWAYS);
        return spacer;
    }

    public boolean hasSelectedToggle() {
        return this.toggleButtonGroup.getSelectedToggle() != null;
    }

    public BlockSize getToggleButtonBlockSize() {
        Toggle btn = this.toggleButtonGroup.getSelectedToggle();
        BlockSize blockSize = null;
        if (btn != null) {
            blockSize = ((ShapeToggleButton)btn).getBlockSize();
        }
        return blockSize;
    }

    public BlockType getToggleButtonBlockType() {
        Toggle btn = this.toggleButtonGroup.getSelectedToggle();
        BlockType blockType = null;
        if (btn != null) {
            blockType = ((ShapeToggleButton)btn).getBlockType();
        }
        return blockType;
    }
}

