/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import java.util.ArrayList;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import tarski.core.block.Block;
import tarski.core.block.BlockSize;
import tarski.core.block.BlockType;
import tarski.core.controller.WorldController;
import tarski.gui.world.UIBlock;
import tarski.gui.world.UITile;
import tarski.gui.world.WorldEditTips;
import tarski.gui.world.WorldEditor;
import tarski.gui.world.WorldInfoBar;

public class UIWorld
extends Pane {
    public static final double MIN_WORLD_SIZE = 350.0;
    public static SimpleDoubleProperty WORLD_SIZE;
    public static SimpleDoubleProperty TILE_SIZE;
    private static final int TILE_NUMBER_PER_LINE = 8;
    public static final int SEPERATOR_SIZE = 4;
    public static final String DEFAULT_BLOCK_NAME = "";
    private ArrayList<ArrayList<UITile>> tiles;
    private Group tileGroup = new Group();
    private Group blockGroup = new Group();
    private WorldEditor worldEditor;
    private WorldInfoBar worldInfoBar;
    private Pane gridPane;
    private HBox worldHbox;
    private WorldController worldController;

    public UIWorld(WorldController worldController) {
        WORLD_SIZE = new SimpleDoubleProperty();
        WORLD_SIZE.setValue((int)this.getWidth());
        TILE_SIZE = new SimpleDoubleProperty();
        TILE_SIZE.setValue(WORLD_SIZE.getValue() / 8.0 - 4.0);
        this.worldController = worldController;
        this.worldEditor = new WorldEditor();
        this.worldInfoBar = new WorldInfoBar(worldController);
        this.getStyleClass().add("world");
        this.gridPane = new Pane();
        this.gridPane.getChildren().addAll((Node[])new Node[]{this.tileGroup, this.blockGroup});
        this.setPickOnBounds(false);
        this.tiles = new ArrayList();
        for (int i = 0; i < 8; ++i) {
            this.tiles.add(new ArrayList());
        }
        for (int row = 0; row < 8; ++row) {
            for (int column = 0; column < 8; ++column) {
                UITile newTile = new UITile(column, row);
                this.tiles.get(row).add(column, newTile);
                this.tileGroup.getChildren().add(newTile);
            }
        }
        for (Block block : worldController.getBlocks()) {
            this.makeBlockNoController(block.getBlockType(), block.getBlockSize(), block.getGridPosX(), block.getGridPosY(), block.getName());
        }
        VBox worldVbox = new VBox();
        this.worldHbox = new HBox();
        worldVbox.getChildren().addAll((Node[])new Node[]{this.gridPane, this.worldInfoBar});
        this.worldHbox.getChildren().addAll((Node[])new Node[]{this.worldEditor, worldVbox});
        this.getChildren().add(this.worldHbox);
        this.widthProperty().addListener((observable, oldVal, newVal) -> this.updateWorldWidth(newVal.intValue()));
        this.heightProperty().addListener((observable, oldVal, newVal) -> this.updateWorldHeight(newVal.intValue()));
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                if (this.worldEditor.hasSelectedToggle()) {
                    this.worldInfoBar.stackInfoTip(WorldEditTips.GRID_SELECTED_SHAPE);
                } else {
                    this.worldInfoBar.stackInfoTip(WorldEditTips.GRID_NO_SHAPE);
                }
            } else {
                this.worldInfoBar.PopTopTip();
            }
        });
        this.worldEditor.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.worldInfoBar.stackInfoTip(WorldEditTips.TOGGLE_MENU);
            } else {
                this.worldInfoBar.PopTopTip();
            }
        });
        this.setupEventHandling();
    }

    public void updateWorldHeight(double newSize) {
        double height = this.getHeight();
        double width = this.getWidth();
        double worldHeight = newSize - this.worldInfoBar.getHeight();
        double worldWidth = worldHeight + this.worldEditor.getWidth();
        if (worldHeight <= height && worldWidth <= width && worldHeight > 350.0) {
            WORLD_SIZE.setValue(newSize - this.worldInfoBar.getHeight());
            TILE_SIZE.set(WORLD_SIZE.getValue() / 8.0 - 4.0);
            this.gridPane.setMaxHeight(WORLD_SIZE.getValue() - 4.0);
            this.gridPane.setMaxWidth(WORLD_SIZE.getValue() - 4.0);
        }
    }

    public void updateWorldWidth(double newSize) {
        double height = this.getHeight();
        double width = this.getWidth();
        double worldWidth = newSize - this.worldEditor.getWidth();
        double worldHeight = worldWidth + this.worldInfoBar.getHeight();
        if (worldWidth <= width && worldHeight <= height && worldWidth > 350.0) {
            WORLD_SIZE.setValue(newSize - this.worldEditor.getWidth());
            TILE_SIZE.set(WORLD_SIZE.getValue() / 8.0 - 4.0);
            this.gridPane.setMaxHeight(WORLD_SIZE.getValue() - 4.0);
            this.gridPane.setMaxWidth(WORLD_SIZE.getValue() - 4.0);
        }
    }

    private void makeBlockNoController(BlockType blockType, BlockSize blockSize, int row, int column, String name) {
        UIBlock uiBlock = new UIBlock(this.worldController, this, blockType, blockSize, row, column, name);
        uiBlock.setOnMouseReleased(event -> {
            this.moveBlock(uiBlock);
            this.setViewOrder(1.0);
        });
        uiBlock.setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
                uiBlock.openBlockNameEditor();
            }
        });
        uiBlock.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.worldInfoBar.stackInfoTip(WorldEditTips.BLOCK);
            } else {
                this.worldInfoBar.PopTopTip();
            }
        });
        this.tiles.get(row).get(column).setUIBlock(uiBlock);
        this.blockGroup.getChildren().add(uiBlock);
        uiBlock.requestFocus();
    }

    public void makeBlock(BlockType blockType, BlockSize blockSize, int row, int column, String name) {
        if (this.worldController.makeBlock(blockSize, blockType, row, column)) {
            this.makeBlockNoController(blockType, blockSize, row, column, name);
        }
    }

    private void moveBlock(UIBlock uiBlock) {
        int oldY;
        int newX = this.positionToBoardCoord(uiBlock.getXPos());
        int newY = this.positionToBoardCoord(uiBlock.getYPos());
        int oldX = this.positionToBoardCoord(uiBlock.getOldX());
        if (this.worldController.moveBlock(oldX, oldY = this.positionToBoardCoord(uiBlock.getOldY()), newX, newY)) {
            uiBlock.move(newX, newY);
            this.tiles.get(oldX).get(oldY).removeUIBlock();
            this.tiles.get(newX).get(newY).setUIBlock(uiBlock);
        } else {
            uiBlock.cancelLastMove();
        }
    }

    private void removeBlock(int row, int column) {
        if (this.worldController.removeBlock(row, column)) {
            UITile uiTile = this.tiles.get(row).get(column);
            uiTile.getUIBlock().requestFocus();
            this.blockGroup.getChildren().remove(uiTile.getUIBlock());
            uiTile.removeUIBlock();
        }
    }

    public WorldController getWorldController() {
        return this.worldController;
    }

    public int positionToBoardCoord(double pos) {
        return (int)Math.floor(pos / (TILE_SIZE.getValue() + 4.0));
    }

    private void setupEventHandling() {
        this.gridPane.setOnMousePressed(event -> {
            this.gridPane.requestFocus();
            int row = this.positionToBoardCoord(event.getX());
            int column = this.positionToBoardCoord(event.getY());
            if (event.isPrimaryButtonDown()) {
                if (this.worldEditor.hasSelectedToggle()) {
                    BlockType blockType = this.worldEditor.getToggleButtonBlockType();
                    BlockSize blockSize = this.worldEditor.getToggleButtonBlockSize();
                    this.makeBlock(blockType, blockSize, row, column, DEFAULT_BLOCK_NAME);
                }
            } else if (event.isSecondaryButtonDown()) {
                this.removeBlock(row, column);
            }
        });
    }

    public void triggerErrorBlockFade(int gridPosX, int gridPosY) {
        UITile redTile = new UITile(gridPosX, gridPosY, "-fx-fill: #e82c2c;");
        this.tileGroup.getChildren().add(redTile);
        ParallelTransition parTrans = new ParallelTransition();
        parTrans.setOnFinished(event -> {
            FadeTransition fadeOut = new FadeTransition(Duration.seconds(0.5), redTile);
            fadeOut.setFromValue(0.8);
            fadeOut.setToValue(0.0);
            fadeOut.play();
            fadeOut.setOnFinished(eventFadeOut -> this.tileGroup.getChildren().remove(redTile));
        });
        redTile.toFront();
        parTrans.play();
    }
}

