/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import javafx.scene.shape.Rectangle;
import tarski.gui.world.UIBlock;
import tarski.gui.world.UIWorld;

public class UITile
extends Rectangle {
    private UIBlock uiBlock;
    private int x;
    private int y;

    public UITile(int x, int y) {
        this.x = x;
        this.y = y;
        this.widthProperty().bind(UIWorld.TILE_SIZE);
        this.heightProperty().bind(UIWorld.TILE_SIZE);
        this.widthProperty().addListener((observable, oldVal, newVal) -> this.positionTile());
        this.positionTile();
        this.getStyleClass().add("tile");
    }

    public UITile(int x, int y, String style) {
        this(x, y);
        this.getStyleClass().clear();
        this.setStyle(style);
    }

    private void positionTile() {
        this.relocate((double)this.x * (UIWorld.TILE_SIZE.getValue() + 4.0), (double)this.y * (UIWorld.TILE_SIZE.getValue() + 4.0));
    }

    public void setUIBlock(UIBlock uiBlock) {
        this.uiBlock = uiBlock;
    }

    public void removeUIBlock() {
        this.uiBlock = null;
    }

    public UIBlock getUIBlock() {
        return this.uiBlock;
    }
}

