/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import tarski.core.block.BlockSize;
import tarski.core.block.BlockType;
import tarski.core.controller.WorldController;
import tarski.gui.world.BlockLabel;
import tarski.gui.world.UIWorld;

public class UIBlock
extends StackPane {
    private BlockSize blockSize;
    private SimpleDoubleProperty pathSize = new SimpleDoubleProperty();
    private double oldX;
    private double oldY;
    private double gridPosX;
    private double gridPosY;
    private double curMouseX;
    private double curMouseY;
    private BlockLabel blockLabel;

    public UIBlock(WorldController worldController, UIWorld uiWorld, BlockType blockType, BlockSize blockSize, double x, double y, String blockName) {
        this.blockSize = blockSize;
        this.gridPosX = x;
        this.gridPosY = y;
        Region svgShape = new Region();
        switch (blockType) {
            case SQUARE: {
                svgShape.getStyleClass().add("shape-square");
                break;
            }
            case TRIANGLE: {
                svgShape.getStyleClass().add("shape-triangle");
                break;
            }
            case PENTAGON: {
                svgShape.getStyleClass().add("shape-pentagon");
            }
        }
        switch (blockSize) {
            case SMALL: {
                svgShape.getStyleClass().add("shape-color-small");
                break;
            }
            case MEDIUM: {
                svgShape.getStyleClass().add("shape-color-medium");
                break;
            }
            case LARGE: {
                svgShape.getStyleClass().add("shape-color-large");
            }
        }
        UIWorld.TILE_SIZE.addListener((ChangeListener<? super Number>)((ChangeListener<Number>)(observable, oldVal, newVal) -> {
            this.calculatePathSize();
            this.move(this.gridPosX, this.gridPosY);
        }));
        this.blockLabel = new BlockLabel(worldController, uiWorld, this, blockName, this.pathSize);
        this.calculatePathSize();
        svgShape.getStyleClass().add("grid-shape");
        svgShape.minWidthProperty().bind(this.pathSize);
        svgShape.minHeightProperty().bind(this.pathSize);
        svgShape.prefWidthProperty().bind(this.pathSize);
        svgShape.prefHeightProperty().bind(this.pathSize);
        svgShape.maxWidthProperty().bind(this.pathSize);
        svgShape.maxHeightProperty().bind(this.pathSize);
        this.getChildren().addAll((Node[])new Node[]{svgShape, this.blockLabel});
        this.move(x, y);
        this.setOnMousePressed(event -> {
            this.curMouseX = event.getSceneX();
            this.curMouseY = event.getSceneY();
            this.toFront();
            this.requestFocus();
        });
        this.setOnMouseDragged(event -> this.relocate(event.getSceneX() - this.curMouseX + this.oldX, event.getSceneY() - this.curMouseY + this.oldY));
    }

    public void updateOnResize(double x, double y) {
        this.calculatePathSize();
        this.move(this.getGridXPos(), this.getGridYPos());
    }

    private void calculatePathSize() {
        switch (this.blockSize) {
            case SMALL: {
                this.pathSize.setValue(UIWorld.TILE_SIZE.getValue() - 40.0);
                break;
            }
            case MEDIUM: {
                this.pathSize.setValue(UIWorld.TILE_SIZE.getValue() - 25.0);
                break;
            }
            case LARGE: {
                this.pathSize.setValue(UIWorld.TILE_SIZE.getValue() - 10.0);
            }
        }
        if (this.pathSize.getValue() < 10.0) {
            this.pathSize.setValue(10);
        }
    }

    public void openBlockNameEditor() {
        this.blockLabel.openLabelEditor();
    }

    public void move(double x, double y) {
        this.gridPosX = x;
        this.gridPosY = y;
        double shapeSizeCenterSpacing = UIWorld.TILE_SIZE.getValue() / 2.0 - this.pathSize.getValue() / 2.0;
        double tileOffsetSize = UIWorld.TILE_SIZE.getValue() + 4.0;
        this.oldX = x * tileOffsetSize + shapeSizeCenterSpacing;
        this.oldY = y * tileOffsetSize + shapeSizeCenterSpacing;
        this.relocate(this.oldX, this.oldY);
    }

    public void cancelLastMove() {
        this.relocate(this.oldX, this.oldY);
    }

    public double getOldX() {
        return this.oldX;
    }

    public double getOldY() {
        return this.oldY;
    }

    public double getXPos() {
        return this.getLayoutX() + this.pathSize.getValue() / 2.0;
    }

    public double getYPos() {
        return this.getLayoutY() + this.pathSize.getValue() / 2.0;
    }

    public int getGridXPos() {
        return (int)this.gridPosX;
    }

    public int getGridYPos() {
        return (int)this.gridPosY;
    }
}

