/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.world;

import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.TextFormatter;
import tarski.core.controller.BlockPos;
import tarski.core.controller.WorldController;
import tarski.gui.common.EditableLabel;
import tarski.gui.world.UIBlock;
import tarski.gui.world.UIWorld;

public class BlockLabel
extends EditableLabel {
    private WorldController worldController;
    private UIBlock uiBlock;

    public BlockLabel(WorldController worldController, UIWorld uiWorld, UIBlock uiBlock, String name, SimpleDoubleProperty blockPxSize) {
        super(name);
        this.uiBlock = uiBlock;
        blockPxSize.addListener((ChangeListener<? super Number>)((ChangeListener<Number>)(observable, oldVal, newVal) -> this.textField.setMaxSize(newVal.doubleValue() - newVal.doubleValue() / 2.0, newVal.doubleValue())));
        this.worldController = worldController;
        this.textField.setTextFormatter(new TextFormatter(change -> {
            String newText = change.getControlNewText();
            if (!worldController.setBlockName(uiBlock.getGridXPos(), uiBlock.getGridYPos(), newText)) {
                BlockPos collidingBlock = worldController.getBlockWithNameCollision(uiBlock.getGridXPos(), uiBlock.getGridYPos(), newText);
                if (collidingBlock != null) {
                    uiWorld.triggerErrorBlockFade(collidingBlock.getxPos(), collidingBlock.getyPos());
                }
                change.setText("");
            }
            return change;
        }));
    }

    @Override
    public void updateText() {
        String newName;
        int blockPosY;
        int blockPosX = this.uiBlock.getGridXPos();
        if (this.worldController.setBlockName(blockPosX, blockPosY = this.uiBlock.getGridYPos(), newName = this.textField.getText())) {
            this.setText(newName);
        }
        this.setGraphic(null);
    }
}

