/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview.treeitem;

import com.jfoenix.controls.JFXButton;
import java.util.Arrays;
import javafx.scene.control.MenuItem;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.core.controller.WorldController;
import tarski.gui.common.AlertMaker;
import tarski.gui.common.ContextMenuMaker;
import tarski.gui.common.IconMaker;
import tarski.gui.treeview.FormulaTreeManager;
import tarski.gui.treeview.WorldEditableLabel;
import tarski.gui.treeview.treeitem.AbstractTreeItem;

public class WorldTreeItem
extends AbstractTreeItem {
    private WorldEditableLabel itemLabel = new WorldEditableLabel((WorldController)this.getValue());

    public WorldTreeItem(FormulaTreeManager formulaTreeManager, Controller<?> controller) {
        super(formulaTreeManager, controller);
        MenuItem removeWorld = new MenuItem("Delete", IconMaker.makeIconLabelDanger(MaterialDesign.MDI_DELETE));
        removeWorld.getStyleClass().add("menu-item-danger");
        MenuItem renameWorld = new MenuItem("Rename", IconMaker.makeIconLabel(MaterialDesign.MDI_LEAD_PENCIL));
        removeWorld.setOnAction(event -> {
            JFXButton yesButton = new JFXButton("Yes");
            yesButton.getStyleClass().add("dialog-button");
            JFXButton cancelButton = new JFXButton("Cancel");
            yesButton.setOnAction(yesButtonEvent -> {
                formulaTreeManager.removeWorld(this);
                formulaTreeManager.setQuestionWindowToEditorView();
            });
            AlertMaker.showMaterialDialog(Arrays.asList(yesButton, cancelButton), "Confirm removal", "Are you sure you want to remove " + this.itemLabel.getText() + " ?");
        });
        renameWorld.setOnAction(event -> this.itemLabel.openLabelEditor());
        this.contextMenu = ContextMenuMaker.makeContextMenu(Arrays.asList(renameWorld, removeWorld));
    }

    public WorldEditableLabel getItemLabel() {
        return this.itemLabel;
    }
}

