/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview.treeitem;

import com.jfoenix.controls.JFXButton;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.core.controller.QuestionController;
import tarski.gui.common.AlertMaker;
import tarski.gui.common.ContextMenuMaker;
import tarski.gui.common.IconMaker;
import tarski.gui.treeview.FormulaEditableLabel;
import tarski.gui.treeview.FormulaTreeManager;
import tarski.gui.treeview.treeitem.AbstractTreeItem;

public class FormulaTreeItem
extends AbstractTreeItem {
    private FormulaEditableLabel itemLabel;

    public FormulaTreeItem(FormulaTreeManager formulaTreeManager, Controller<?> controller) {
        super(formulaTreeManager, controller);
        this.itemLabel = new FormulaEditableLabel((QuestionController)controller);
        MenuItem addWorld = new MenuItem("New world", IconMaker.makeIconLabel(MaterialDesign.MDI_PLUS));
        final MenuItem clearWorlds = new MenuItem("Clear formula worlds", IconMaker.makeIconLabelDanger(MaterialDesign.MDI_CLOSE));
        clearWorlds.getStyleClass().add("menu-item-danger");
        MenuItem renameFormula = new MenuItem("Rename", IconMaker.makeIconLabel(MaterialDesign.MDI_LEAD_PENCIL));
        MenuItem removeFormula = new MenuItem("Delete", IconMaker.makeIconLabelDanger(MaterialDesign.MDI_DELETE));
        removeFormula.getStyleClass().add("menu-item-danger");
        addWorld.setOnAction(event -> formulaTreeManager.createNewWorldItem(this));
        if (this.getChildren().isEmpty()) {
            clearWorlds.setDisable(true);
        }
        this.getChildren().addListener(change -> {
            if (!change.getList().isEmpty()) {
                clearWorlds.setDisable(false);
            } else {
                clearWorlds.setDisable(true);
            }
        });
        clearWorlds.setOnAction(event -> {
            JFXButton yesButton = new JFXButton("Yes");
            JFXButton cancelButton = new JFXButton("Cancel");
            yesButton.setOnAction(yesButtonEvent -> Platform.runLater(() -> formulaTreeManager.clearWorlds(this)));
            AlertMaker.showMaterialDialog(Arrays.asList(yesButton, cancelButton), "Confirm removal", "Are you sure you want to clear all worlds for " + this.itemLabel.getText() + " ?");
        });
        this.getChildren().addListener(new ListChangeListener<TreeItem<Controller<?>>>(){
            final /* synthetic */ FormulaTreeItem this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChanged(ListChangeListener.Change<? extends TreeItem<Controller<?>>> changed) {
                if (!changed.getList().isEmpty()) {
                    clearWorlds.setDisable(false);
                } else {
                    clearWorlds.setDisable(true);
                }
            }
        });
        renameFormula.setOnAction(event -> this.itemLabel.openLabelEditor());
        removeFormula.setOnAction(event -> {
            JFXButton yesButton = new JFXButton("Yes");
            JFXButton cancelButton = new JFXButton("Cancel");
            yesButton.setOnAction(yesButtonEvent -> {
                formulaTreeManager.removeFormula(this);
                Platform.runLater(() -> formulaTreeManager.clearQuestionWindow());
            });
            AlertMaker.showMaterialDialog(Arrays.asList(yesButton, cancelButton), "Confirm removal", "Are you sure you want to remove " + this.itemLabel.getText() + " ?");
        });
        this.contextMenu = ContextMenuMaker.makeContextMenu(Arrays.asList(addWorld, clearWorlds, new SeparatorMenuItem(), renameFormula, removeFormula));
    }

    public FormulaEditableLabel getItemLabel() {
        return this.itemLabel;
    }
}

