/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import tarski.core.controller.QuestionController;
import tarski.core.controller.WorldController;
import tarski.gui.common.EditableLabel;

public class WorldEditableLabel
extends EditableLabel {
    private WorldController worldController;
    private QuestionController questionController;

    public WorldEditableLabel(WorldController worldController) {
        super(worldController.getName());
        this.worldController = worldController;
        this.questionController = (QuestionController)worldController.getParent();
        this.textField.setMaxSize(100.0, 30.0);
        this.textProperty().bind(worldController.nameProperty());
        worldController.getParentProperty().addListener((val, oldVal, newVal) -> {
            this.questionController = (QuestionController)newVal;
        });
    }

    @Override
    public void updateText() {
        String newName = this.textField.getText();
        this.questionController.renameElement(this.worldController, newName);
        this.setGraphic(null);
        this.textProperty().bind(this.worldController.nameProperty());
    }

    @Override
    public void openLabelEditor() {
        this.wasSetByAction = false;
        this.oldText = this.getText();
        this.textProperty().unbind();
        this.setText("");
        this.textField.setText(this.oldText);
        this.setGraphic(this.textField);
        this.textField.selectAll();
        this.textField.requestFocus();
    }
}

