/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import com.jfoenix.controls.JFXButton;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.gui.common.IconMaker;
import tarski.gui.treeview.FormulaTreeManager;

public class TreeViewToolBar
extends AnchorPane {
    private FormulaTreeManager formulaTreeManager;
    private HBox leftHbox;
    private HBox rightHbox;

    public TreeViewToolBar(FormulaTreeManager formulaTreeManager) {
        this.formulaTreeManager = formulaTreeManager;
        this.leftHbox = new HBox();
        this.rightHbox = new HBox();
        this.leftHbox.setAlignment(Pos.CENTER_LEFT);
        this.rightHbox.setAlignment(Pos.CENTER_RIGHT);
        this.getStyleClass().add("tree-view-toolbar");
        Label treeViewTitle = new Label("Formula: tests");
        treeViewTitle.getStyleClass().add("tree-view-toolbar-label");
        this.leftHbox.getChildren().add(treeViewTitle);
        this.rightHbox.getChildren().add(this.makeEvalAllFormulasButton());
        this.getChildren().addAll((Node[])new Node[]{this.leftHbox, this.rightHbox});
        AnchorPane.setLeftAnchor(this.leftHbox, 5.0);
        AnchorPane.setTopAnchor(this.leftHbox, 5.0);
        AnchorPane.setBottomAnchor(this.leftHbox, 5.0);
        AnchorPane.setRightAnchor(this.rightHbox, 5.0);
        AnchorPane.setTopAnchor(this.rightHbox, 0.0);
        AnchorPane.setBottomAnchor(this.rightHbox, 0.0);
    }

    public JFXButton makeEvalAllFormulasButton() {
        JFXButton evalAllButton = IconMaker.makeIconButton(MaterialDesign.MDI_PLAY, "eval-all-button");
        evalAllButton.getStyleClass().add("eval-formulas-button");
        evalAllButton.setOnAction(event -> this.formulaTreeManager.evalAll());
        return evalAllButton;
    }
}

