/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import java.util.Objects;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import tarski.core.controller.Controller;
import tarski.gui.treeview.CustomCell;
import tarski.gui.treeview.FormulaTreeManager;

public class TreeCellFactory
implements Callback<TreeView<Controller<?>>, TreeCell<Controller<?>>> {
    private FormulaTreeManager formulaTreeManager;
    private static final DataFormat JAVA_FORMAT = new DataFormat("application/x-java-serialized-object");
    private TreeCell<Controller<?>> dropZone;
    private CustomCell draggedCell;
    private TreeView<Controller<?>> treeView;

    public TreeCellFactory(FormulaTreeManager formulaTreeManager) {
        this.formulaTreeManager = formulaTreeManager;
    }

    @Override
    public TreeCell<Controller<?>> call(TreeView<Controller<?>> param) {
        CustomCell cell = new CustomCell(this.formulaTreeManager);
        this.treeView = this.formulaTreeManager.getTreeView();
        cell.setOnDragDetected(event -> this.onDragDetected((MouseEvent)event, cell, this.treeView));
        cell.setOnDragOver(event -> this.onDragOver((DragEvent)event, cell, this.treeView));
        cell.setOnDragDropped(event -> this.onDragDropped((DragEvent)event, cell, this.treeView));
        cell.setOnDragDone(event -> this.onDragDone());
        return cell;
    }

    private void onDragDetected(MouseEvent event, CustomCell treeCell, TreeView<Controller<?>> treeView) {
        this.draggedCell = treeCell;
        if (treeCell == null || this.draggedCell == null || this.draggedCell.getTreeItem() == null) {
            return;
        }
        if (this.draggedCell.getTreeItem().getParent() == null) {
            return;
        }
        Dragboard db = treeCell.startDragAndDrop(TransferMode.MOVE);
        ClipboardContent content = new ClipboardContent();
        content.put(JAVA_FORMAT, this.draggedCell.getTreeItem().getValue());
        db.setContent(content);
        db.setDragView(treeCell.snapshot(null, null));
    }

    private void onDragOver(DragEvent event, CustomCell treeCell, TreeView<Controller<?>> treeView) {
        if (!event.getDragboard().hasContent(JAVA_FORMAT)) {
            return;
        }
        TreeItem thisItem = treeCell.getTreeItem();
        int draggedItemLevel = treeView.getTreeItemLevel(this.draggedCell.getTreeItem());
        int thisItemLevel = treeView.getTreeItemLevel(thisItem);
        if (this.draggedCell.getTreeItem() == null || thisItem == null || thisItem == this.draggedCell.getTreeItem()) {
            return;
        }
        if (this.draggedCell.getTreeItem().getParent() == null) {
            this.onDragDone();
            return;
        }
        if (this.draggedCell.getTreeItem().getParent().equals(thisItem)) {
            this.onDragDone();
            return;
        }
        if (thisItemLevel != draggedItemLevel && draggedItemLevel == 1) {
            return;
        }
        if (this.draggedCell.getTreeItem().getParent().getChildren().indexOf(this.draggedCell.getTreeItem()) - 1 == thisItem.getParent().getChildren().indexOf(thisItem) && thisItem.getParent().equals(this.draggedCell.getTreeItem().getParent())) {
            return;
        }
        event.acceptTransferModes(TransferMode.MOVE);
        if (!Objects.equals(this.dropZone, treeCell)) {
            this.onDragDone();
            this.dropZone = treeCell;
            if (thisItemLevel != draggedItemLevel) {
                this.dropZone.getStyleClass().add("tree-cell-dnd");
            } else {
                this.dropZone.getStyleClass().add("drag-n-drop-line");
            }
        }
    }

    private void onDragDropped(DragEvent event, CustomCell treeCell, TreeView<Controller<?>> treeView) {
        Dragboard db = event.getDragboard();
        TreeItem<Controller<?>> draggedItem = this.draggedCell.getTreeItem();
        if (!db.hasContent(JAVA_FORMAT)) {
            return;
        }
        TreeItem<Controller<?>> thisItem = treeCell.getTreeItem();
        this.formulaTreeManager.moveItemPosition(thisItem, draggedItem);
        event.setDropCompleted(true);
        this.formulaTreeManager.openWindowFromItem(draggedItem);
    }

    private void onDragDone() {
        if (this.dropZone != null) {
            this.dropZone.getStyleClass().remove("drag-n-drop-line");
            this.dropZone.getStyleClass().remove("tree-cell-dnd");
        }
    }
}

