/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import com.jfoenix.controls.JFXButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.core.controller.DataController;
import tarski.core.controller.QuestionController;
import tarski.core.controller.WorldController;
import tarski.core.parser.EvalResult;
import tarski.gui.common.AlertMaker;
import tarski.gui.common.ContextMenuMaker;
import tarski.gui.common.IconMaker;
import tarski.gui.question.QuestionWindow;
import tarski.gui.treeview.TreeCellFactory;
import tarski.gui.treeview.TreeViewToolBar;
import tarski.gui.treeview.treeitem.FormulaTreeItem;
import tarski.gui.treeview.treeitem.WorldTreeItem;

public class FormulaTreeManager {
    private VBox treeViewPanel;
    private TreeView<Controller<?>> treeView;
    private DataController dataController;
    private AnchorPane editorPane;
    private QuestionWindow questionWindow;
    private QuestionController activeController;
    private ContextMenu contextMenu;
    public static final int FORMULA_LEVEL = 1;
    public static final int WORLD_LEVEL = 2;

    public FormulaTreeManager(DataController dataController, AnchorPane editorPane) {
        this.dataController = dataController;
        this.editorPane = editorPane;
        this.treeViewPanel = new VBox();
        TreeItem<DataController> root = new TreeItem<DataController>(dataController);
        root.setExpanded(true);
        this.treeView = new TreeView<DataController>(root);
        this.treeView.setShowRoot(false);
        this.treeView.setCellFactory(new TreeCellFactory(this));
        this.contextMenu = this.createContextMenu();
        this.treeView.setContextMenu(this.contextMenu);
        this.loadFormulas();
        this.treeViewPanel.getChildren().addAll((Node[])new Node[]{new TreeViewToolBar(this), this.treeView});
    }

    public void clearRessources() {
        if (this.questionWindow != null) {
            this.questionWindow.clearRessources();
        }
    }

    public void openWindowFromItem(TreeItem<Controller<?>> selectedItem) {
        int itemLevel = this.treeView.getTreeItemLevel(selectedItem);
        if (this.questionWindow != null) {
            this.questionWindow.clearRessources();
        }
        switch (itemLevel) {
            case 1: {
                this.activeController = (QuestionController)selectedItem.getValue();
                this.questionWindow = new QuestionWindow(this.activeController);
                this.editorPane.getChildren().clear();
                this.setQuestionWindow(this.questionWindow);
                this.questionWindow.showEditorView();
                break;
            }
            case 2: {
                WorldController worldController = (WorldController)selectedItem.getValue();
                this.activeController = (QuestionController)selectedItem.getParent().getValue();
                this.questionWindow = new QuestionWindow(this.activeController);
                this.setQuestionWindow(this.questionWindow);
                this.questionWindow.showWorld(worldController);
            }
        }
    }

    private void setQuestionWindow(QuestionWindow questionWindow) {
        this.editorPane.getChildren().clear();
        AnchorPane.setTopAnchor(questionWindow, 0.0);
        AnchorPane.setBottomAnchor(questionWindow, 0.0);
        AnchorPane.setLeftAnchor(questionWindow, 0.0);
        AnchorPane.setRightAnchor(questionWindow, 0.0);
        this.editorPane.getChildren().add(questionWindow);
    }

    public void setQuestionWindowToEditorView() {
        this.questionWindow.showEditorView();
    }

    public void clearQuestionWindow() {
        this.editorPane.getChildren().remove(this.questionWindow);
    }

    public void evalAll() {
        ((DataController)this.treeView.getRoot().getValue()).evalAll();
    }

    public EvalResult evalFormulaWorlds(TreeItem<Controller<?>> formulaItem) {
        EvalResult formulaResult = ((QuestionController)formulaItem.getValue()).evalWorlds();
        return formulaResult;
    }

    public EvalResult evalWorld(TreeItem<Controller<?>> worldItem) {
        WorldController worldController = (WorldController)worldItem.getValue();
        QuestionController controller = (QuestionController)worldItem.getParent().getValue();
        EvalResult result = controller.evalWorld(worldController);
        return result;
    }

    public void clearWorlds(TreeItem<Controller<?>> formulaItem) {
        ArrayList<TreeItem> toRemove = new ArrayList<TreeItem>();
        for (TreeItem treeItem : formulaItem.getChildren()) {
            this.removeWorldFromController(treeItem);
            toRemove.add(treeItem);
        }
        formulaItem.getChildren().removeAll((Collection<?>)toRemove);
    }

    public void removeWorld(TreeItem<Controller<?>> worldItem) {
        this.removeWorldFromController(worldItem);
        worldItem.getParent().getChildren().remove(worldItem);
    }

    private void removeWorldFromController(TreeItem<Controller<?>> worldItem) {
        WorldController worldController = (WorldController)worldItem.getValue();
        QuestionController formulaController = (QuestionController)worldItem.getParent().getValue();
        formulaController.removeElement(worldController);
    }

    public void clearAllFormulas() {
        ArrayList<TreeItem> toRemove = new ArrayList<TreeItem>();
        for (TreeItem treeItem : this.treeView.getRoot().getChildren()) {
            this.removeFormulaFromController(treeItem);
            toRemove.add(treeItem);
        }
        this.treeView.getRoot().getChildren().removeAll((Collection<?>)toRemove);
    }

    public void removeFormula(TreeItem<Controller<?>> formulaItem) {
        this.clearWorlds(formulaItem);
        this.removeFormulaFromController(formulaItem);
        this.treeView.getRoot().getChildren().remove(formulaItem);
    }

    private void removeFormulaFromController(TreeItem<Controller<?>> formulaItem) {
        this.dataController.removeElement((QuestionController)formulaItem.getValue());
    }

    public void showDefaultView() {
        this.editorPane.getChildren().clear();
        this.treeView.getSelectionModel().select(null);
    }

    private void loadFormulas() {
        List controllerQuestions = this.dataController.getElements();
        for (QuestionController currentQuestion : controllerQuestions) {
            this.createTreeQuestionNode(currentQuestion);
        }
        if (controllerQuestions.isEmpty()) {
            this.createTreeQuestionNode((QuestionController)this.dataController.createElement());
        }
    }

    private TreeItem<Controller<?>> createTreeQuestionNode(QuestionController questionController) {
        FormulaTreeItem newQuestionItem = new FormulaTreeItem(this, questionController);
        for (WorldController currentWorld : questionController.getElements()) {
            TreeItem<Controller<?>> newWorldItem = this.createTreeWorldNode(currentWorld);
            newQuestionItem.getChildren().add(newWorldItem);
        }
        this.treeView.getRoot().getChildren().add(newQuestionItem);
        return newQuestionItem;
    }

    public TreeView<Controller<?>> getTreeView() {
        return this.treeView;
    }

    public Pane getTreeViewPane() {
        return this.treeViewPanel;
    }

    public void createNewWorldItem(TreeItem<Controller<?>> formulaItem) {
        TreeItem<Controller<?>> newWorldItem = this.createNewWorld(formulaItem);
        formulaItem.getChildren().add(newWorldItem);
        this.treeView.getSelectionModel().select(newWorldItem);
    }

    private TreeItem<Controller<?>> createNewWorld(TreeItem<Controller<?>> formulaItem) {
        WorldController worldController = (WorldController)((QuestionController)formulaItem.getValue()).createElement();
        TreeItem<Controller<?>> newWorldItem = this.createTreeWorldNode(worldController);
        return newWorldItem;
    }

    public Boolean moveItemPosition(TreeItem<Controller<?>> itemDroppedOn, TreeItem<Controller<?>> draggedItem) {
        Boolean ret = false;
        ret = this.treeView.getTreeItemLevel(draggedItem) == 1 ? this.moveFormulaItem(itemDroppedOn, draggedItem) : this.moveWorldItem(itemDroppedOn, draggedItem);
        return ret;
    }

    private Boolean moveFormulaItem(TreeItem<Controller<?>> itemDroppedOn, TreeItem<Controller<?>> draggedItem) {
        if (this.treeView.getTreeItemLevel(itemDroppedOn) != 1) {
            return false;
        }
        this.treeView.getRoot().getChildren().remove(draggedItem);
        int indexInParent = itemDroppedOn.getParent().getChildren().indexOf(itemDroppedOn);
        itemDroppedOn.getParent().getChildren().add(indexInParent + 1, draggedItem);
        DataController dataController = (DataController)this.treeView.getRoot().getValue();
        dataController.removeElement((QuestionController)draggedItem.getValue());
        if (dataController.addElementAtIndex((QuestionController)draggedItem.getValue(), indexInParent + 1).booleanValue()) {
            this.treeView.getSelectionModel().select(draggedItem);
            return true;
        }
        return false;
    }

    private Boolean moveWorldItem(TreeItem<Controller<?>> itemDroppedOn, TreeItem<Controller<?>> draggedItem) {
        WorldController worldController = (WorldController)draggedItem.getValue();
        Boolean result = false;
        if (this.treeView.getTreeItemLevel(itemDroppedOn) == 1) {
            if (((QuestionController)itemDroppedOn.getValue()).elementNameIsUnique(worldController.getName())) {
                this.removeWorld(draggedItem);
                ((QuestionController)itemDroppedOn.getValue()).addElement(worldController);
                itemDroppedOn.getChildren().add(draggedItem);
                result = true;
            } else {
                this.nameCollisionMovePrompt(itemDroppedOn, draggedItem, itemDroppedOn.getChildren().size() - 1);
            }
        } else {
            TreeItem<Controller<?>> formulaItem = itemDroppedOn.getParent();
            if (((QuestionController)formulaItem.getValue()).elementNameIsUnique(worldController.getName())) {
                this.removeWorld(draggedItem);
                ((QuestionController)formulaItem.getValue()).addElement(worldController);
                formulaItem.getChildren().add(draggedItem);
                result = true;
            } else {
                int dropIndex = formulaItem.getChildren().indexOf(itemDroppedOn);
                this.nameCollisionMovePrompt(formulaItem, draggedItem, dropIndex);
            }
        }
        worldController.resetEvalResult();
        return result;
    }

    private void nameCollisionMovePrompt(TreeItem<Controller<?>> formulaItem, TreeItem<Controller<?>> draggedItem, int index) {
        JFXButton replace = new JFXButton("Replace");
        JFXButton cancel = new JFXButton("Cancel");
        replace.setOnAction(replaceEvent -> this.addWorldAndReplaceOnCollision(formulaItem, draggedItem, index));
        AlertMaker.showMaterialDialog(Arrays.asList(replace, cancel), "World name conflict", "A world has the same name. Would you like to replace the existing one?");
    }

    private void addWorldAndReplaceOnCollision(TreeItem<Controller<?>> formulaItem, TreeItem<Controller<?>> draggedItem, int index) {
        this.removeWorld(draggedItem);
        QuestionController formulaController = (QuestionController)formulaItem.getValue();
        formulaController.addElementAndReplace((WorldController)draggedItem.getValue());
        TreeItem<Controller<?>> itemToReplace = this.getItemByName(formulaItem, draggedItem.getValue().getName());
        formulaItem.getChildren().remove(itemToReplace);
        formulaItem.getChildren().add(index, draggedItem);
    }

    private TreeItem<Controller<?>> getItemByName(TreeItem<Controller<?>> parentItem, String name) {
        for (TreeItem treeItem : parentItem.getChildren()) {
            if (!((Controller)treeItem.getValue()).getName().equals(name)) continue;
            return treeItem;
        }
        return null;
    }

    private TreeItem<Controller<?>> createTreeWorldNode(WorldController worldController) {
        WorldTreeItem newWorldItem = new WorldTreeItem(this, worldController);
        return newWorldItem;
    }

    public ContextMenu createContextMenu() {
        MenuItem addFormula = new MenuItem("New formula", IconMaker.makeIconLabel(MaterialDesign.MDI_PLUS));
        addFormula.setOnAction(event -> {
            TreeItem<Controller<?>> newFormulaItem = this.createTreeQuestionNode((QuestionController)this.dataController.createElement());
            this.treeView.getSelectionModel().select(newFormulaItem);
        });
        MenuItem clearAllFormulas = new MenuItem("Clear all formulas", IconMaker.makeIconLabelDanger(MaterialDesign.MDI_DELETE_SWEEP));
        clearAllFormulas.getStyleClass().add("menu-item-danger");
        if (this.treeView.getRoot().getChildren().isEmpty()) {
            clearAllFormulas.setDisable(true);
        }
        this.treeView.getRoot().getChildren().addListener(change -> {
            if (change.getList().isEmpty()) {
                clearAllFormulas.setDisable(true);
            } else {
                clearAllFormulas.setDisable(false);
            }
        });
        clearAllFormulas.setOnAction(event -> {
            JFXButton yesButton = new JFXButton("Yes");
            JFXButton cancelButton = new JFXButton("Cancel");
            yesButton.setOnAction(yesButtonEvent -> {
                this.showDefaultView();
                Platform.runLater(() -> this.clearAllFormulas());
            });
            AlertMaker.showMaterialDialog(Arrays.asList(yesButton, cancelButton), "Confirm removal", "Are you sure you want to delete all formulas? This action is permanent and cannot be undone.");
        });
        return ContextMenuMaker.makeContextMenu(Arrays.asList(addFormula, new SeparatorMenuItem(), clearAllFormulas));
    }
}

