/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import tarski.core.controller.DataController;
import tarski.core.controller.QuestionController;
import tarski.gui.common.EditableLabel;

public class FormulaEditableLabel
extends EditableLabel {
    private QuestionController questionController;
    private DataController dataController;

    public FormulaEditableLabel(QuestionController questionController) {
        super(questionController.getName());
        this.questionController = questionController;
        this.dataController = (DataController)questionController.getParent();
        this.textField.setMaxSize(100.0, 30.0);
        this.textProperty().bind(questionController.nameProperty());
    }

    @Override
    public void updateText() {
        String newName = this.textField.getText();
        this.dataController.renameElement(this.questionController, newName);
        this.setGraphic(null);
        this.textProperty().bind(this.questionController.nameProperty());
    }

    @Override
    public void openLabelEditor() {
        this.wasSetByAction = false;
        this.oldText = this.getText();
        this.textProperty().unbind();
        this.setText("");
        this.textField.setText(this.oldText);
        this.setGraphic(this.textField);
        this.textField.selectAll();
        this.textField.requestFocus();
    }
}

