/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.treeview;

import com.jfoenix.controls.JFXButton;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.core.parser.EvalResult;
import tarski.gui.common.EditableLabel;
import tarski.gui.common.IconMaker;
import tarski.gui.treeview.FormulaEditableLabel;
import tarski.gui.treeview.FormulaTreeManager;
import tarski.gui.treeview.WorldEditableLabel;
import tarski.gui.treeview.treeitem.FormulaTreeItem;
import tarski.gui.treeview.treeitem.WorldTreeItem;

class CustomCell
extends TreeCell<Controller<?>> {
    private FormulaTreeManager formulaTreeManager;
    private EditableLabel currentLabel;

    public CustomCell(FormulaTreeManager formulaTreeManager) {
        this.formulaTreeManager = formulaTreeManager;
    }

    @Override
    protected void updateItem(Controller<?> item, boolean empty) {
        super.updateItem(item, empty);
        if (this.isEmpty() || item == null) {
            this.setGraphic(null);
            this.setText(null);
            this.setContextMenu(null);
        } else {
            int level = this.getTreeView().getTreeItemLevel(this.getTreeItem());
            switch (level) {
                case 1: {
                    FormulaEditableLabel formulaLabel = ((FormulaTreeItem)this.getTreeItem()).getItemLabel();
                    this.currentLabel = formulaLabel;
                    formulaLabel.setDoubleClickEdit(false);
                    Label formulaCellIconLabel = new Label();
                    this.configureCellIconHandler(formulaCellIconLabel, level);
                    this.updateCellIcon(((Controller)this.getTreeItem().getValue()).getEvalResult(), formulaCellIconLabel, level);
                    this.setContextMenu(((FormulaTreeItem)this.getTreeItem()).getContextMenu());
                    this.setGraphic(this.createFormulaCell(formulaCellIconLabel, formulaLabel));
                    this.setText(null);
                    break;
                }
                case 2: {
                    WorldEditableLabel worldLabel = ((WorldTreeItem)this.getTreeItem()).getItemLabel();
                    this.currentLabel = worldLabel;
                    worldLabel.setDoubleClickEdit(false);
                    Label worldCellIconLabel = new Label();
                    this.configureCellIconHandler(worldCellIconLabel, level);
                    this.updateCellIcon(((Controller)this.getTreeItem().getValue()).getEvalResult(), worldCellIconLabel, level);
                    this.setContextMenu(((WorldTreeItem)this.getTreeItem()).getContextMenu());
                    this.setGraphic(this.createWorldCell(worldCellIconLabel, worldLabel));
                    this.setText(null);
                }
            }
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, (? super T e) -> {
                if (e.getClickCount() >= 2 && e.getButton().equals((Object)MouseButton.PRIMARY)) {
                    this.formulaTreeManager.openWindowFromItem(this.getTreeItem());
                    e.consume();
                }
            });
        }
    }

    public void openLabelNameEditor() {
        this.currentLabel.openLabelEditor();
    }

    private void configureCellIconHandler(final Label label, final int level) {
        Controller controller = (Controller)this.getTreeItem().getValue();
        controller.evalResultProperty().addListener(new ChangeListener<EvalResult>(){
            final /* synthetic */ CustomCell this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void changed(ObservableValue<? extends EvalResult> observable, EvalResult oldValue, EvalResult newValue) {
                this.this$0.updateCellIcon(newValue, label, level);
            }
        });
    }

    private void updateCellIcon(EvalResult result, Label label, int level) {
        if (result == EvalResult.ERROR) {
            IconMaker.updateLabelIcon(label, MaterialDesign.MDI_MINUS_CIRCLE_OUTLINE, "unknown-result-label");
        } else if (result == EvalResult.PASSED) {
            IconMaker.updateLabelIcon(label, MaterialDesign.MDI_CHECK_CIRCLE_OUTLINE, "success-result-label");
        } else if (result == EvalResult.FAILED) {
            IconMaker.updateLabelIcon(label, MaterialDesign.MDI_CLOSE_CIRCLE_OUTLINE, "failure-result-label");
        } else if (result == EvalResult.UNEVALUATED) {
            if (level == 1) {
                IconMaker.updateLabelIcon(label, MaterialDesign.MDI_FUNCTION, "formula-icon-label");
            } else {
                IconMaker.updateLabelIcon(label, MaterialDesign.MDI_CUBE_OUTLINE, "box-icon-label");
            }
        }
    }

    private AnchorPane createWorldCell(Label worldCellIconLabel, WorldEditableLabel worldLabel) {
        JFXButton evalWorldButton = IconMaker.makeIconButton(MaterialDesign.MDI_PLAY, "eval-worlds-button");
        HBox leftWorldHbox = new HBox();
        leftWorldHbox.setSpacing(5.0);
        leftWorldHbox.getChildren().addAll((Node[])new Node[]{worldCellIconLabel, worldLabel});
        evalWorldButton.getStyleClass().add("eval-worlds-button");
        if (this.isSelected()) {
            evalWorldButton.setVisible(true);
        } else {
            evalWorldButton.setVisible(false);
        }
        evalWorldButton.setOnMouseClicked(event -> this.formulaTreeManager.evalWorld(this.getTreeItem()));
        HBox rightWorldHbox = new HBox();
        rightWorldHbox.setSpacing(5.0);
        rightWorldHbox.setAlignment(Pos.CENTER_RIGHT);
        rightWorldHbox.getChildren().add(evalWorldButton);
        AnchorPane worldCellBox = new AnchorPane();
        worldCellBox.getChildren().addAll((Node[])new Node[]{leftWorldHbox, rightWorldHbox});
        AnchorPane.setLeftAnchor(leftWorldHbox, 5.0);
        AnchorPane.setTopAnchor(leftWorldHbox, 0.0);
        AnchorPane.setBottomAnchor(leftWorldHbox, 0.0);
        AnchorPane.setRightAnchor(rightWorldHbox, 5.0);
        AnchorPane.setTopAnchor(rightWorldHbox, 0.0);
        AnchorPane.setBottomAnchor(rightWorldHbox, 0.0);
        return worldCellBox;
    }

    private AnchorPane createFormulaCell(Label formulaCellIconLabel, FormulaEditableLabel questionLabel) {
        JFXButton evalWorldsButton = IconMaker.makeIconButton(MaterialDesign.MDI_PLAY, "eval-worlds-button");
        HBox leftFormulaHbox = new HBox();
        leftFormulaHbox.setSpacing(5.0);
        leftFormulaHbox.setAlignment(Pos.CENTER_LEFT);
        leftFormulaHbox.getChildren().addAll((Node[])new Node[]{formulaCellIconLabel, questionLabel});
        evalWorldsButton.getStyleClass().add("eval-worlds-button");
        if (this.isSelected()) {
            evalWorldsButton.setVisible(true);
        } else {
            evalWorldsButton.setVisible(false);
        }
        evalWorldsButton.setOnMouseClicked(event -> this.formulaTreeManager.evalFormulaWorlds(this.getTreeItem()));
        HBox rightFormulaHbox = new HBox();
        rightFormulaHbox.setSpacing(5.0);
        rightFormulaHbox.setAlignment(Pos.CENTER_RIGHT);
        rightFormulaHbox.getChildren().add(evalWorldsButton);
        AnchorPane questionCellBox = new AnchorPane();
        questionCellBox.getChildren().addAll((Node[])new Node[]{leftFormulaHbox, rightFormulaHbox});
        AnchorPane.setLeftAnchor(leftFormulaHbox, 5.0);
        AnchorPane.setTopAnchor(leftFormulaHbox, 0.0);
        AnchorPane.setBottomAnchor(leftFormulaHbox, 0.0);
        AnchorPane.setRightAnchor(rightFormulaHbox, 5.0);
        AnchorPane.setTopAnchor(rightFormulaHbox, 0.0);
        AnchorPane.setBottomAnchor(rightFormulaHbox, 0.0);
        return questionCellBox;
    }
}

