/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.question;

import com.jfoenix.controls.JFXButton;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.QuestionController;
import tarski.core.controller.WorldController;
import tarski.core.parser.EvalResult;
import tarski.gui.common.IconMaker;
import tarski.gui.debug.DebugFormulaWindow;

public class WorldToolBar
extends AnchorPane {
    private Label treeIndicator;
    private Label formulaName;
    private Label worldName;
    private Label evalStatus;
    private JFXButton debugFormulaButton;
    private JFXButton evalButton;
    private QuestionController questionController;

    public WorldToolBar(QuestionController questionController) {
        this.questionController = questionController;
        this.getStyleClass().add("formula-toolbar");
        this.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        this.evalStatus = new Label();
        this.debugFormulaButton = IconMaker.makeIconButton(MaterialDesign.MDI_BUG, "debug-button-icon", "Debug World");
        this.evalButton = IconMaker.makeIconButton(MaterialDesign.MDI_PLAY, "eval-button-icon", "Eval World");
        this.formulaName = new Label();
        this.worldName = new Label();
        this.treeIndicator = new Label();
        this.formulaName.textProperty().bind(questionController.nameProperty());
        this.treeIndicator.textProperty().bind(Bindings.concat(this.formulaName.textProperty(), " / ", this.worldName.textProperty()));
        this.treeIndicator.getStyleClass().add("tree-indicator");
        this.getChildren().addAll((Node[])new Node[]{this.treeIndicator});
        AnchorPane.setTopAnchor(this.treeIndicator, 5.0);
        AnchorPane.setBottomAnchor(this.treeIndicator, 5.0);
        AnchorPane.setLeftAnchor(this.treeIndicator, 5.0);
    }

    public WorldToolBar(QuestionController questionController, WorldController worldController) {
        this(questionController);
        this.setWorld(worldController);
    }

    public void setWorld(WorldController worldController) {
        this.getChildren().clear();
        this.worldName.textProperty().bind(worldController.nameProperty());
        this.debugFormulaButton = IconMaker.makeIconButton(MaterialDesign.MDI_BUG, "debug-button-icon", "Debug World");
        this.evalButton = IconMaker.makeIconButton(MaterialDesign.MDI_PLAY, "eval-button-icon", "Eval World");
        HBox rightButtons = new HBox();
        rightButtons.setSpacing(5.0);
        rightButtons.setAlignment(Pos.CENTER);
        rightButtons.getChildren().addAll((Node[])new Node[]{this.evalStatus, this.evalButton, this.debugFormulaButton});
        this.evalButton.getStyleClass().add("formula-toolbar-button");
        this.debugFormulaButton.getStyleClass().add("formula-toolbar-button");
        this.debugFormulaButton.setOnAction(event -> {
            EvalResult result = this.questionController.evalWorld(worldController);
            if (result.equals((Object)EvalResult.PASSED) || result.equals((Object)EvalResult.FAILED)) {
                new DebugFormulaWindow(this.questionController);
            }
        });
        this.evalButton.setOnAction(event -> this.questionController.evalWorld(worldController));
        worldController.evalResultProperty().addListener(new ChangeListener<EvalResult>(){

            @Override
            public void changed(ObservableValue<? extends EvalResult> observable, EvalResult oldValue, EvalResult newValue) {
                WorldToolBar.this.updateEvalStatus(newValue);
            }
        });
        this.updateEvalStatus(worldController.getEvalResult());
        AnchorPane.setTopAnchor(this.treeIndicator, 5.0);
        AnchorPane.setBottomAnchor(this.treeIndicator, 5.0);
        AnchorPane.setLeftAnchor(this.treeIndicator, 5.0);
        AnchorPane.setTopAnchor(rightButtons, 5.0);
        AnchorPane.setBottomAnchor(rightButtons, 5.0);
        AnchorPane.setRightAnchor(rightButtons, 5.0);
        this.getChildren().addAll((Node[])new Node[]{this.treeIndicator, rightButtons});
    }

    public void showFormulaOnlyView() {
        this.evalStatus.setVisible(false);
        this.debugFormulaButton.setVisible(false);
        this.evalButton.setVisible(false);
        this.worldName.textProperty().unbind();
        this.worldName.setText("");
    }

    private void updateEvalStatus(EvalResult result) {
        if (result == EvalResult.ERROR) {
            IconMaker.updateLabelIcon(this.evalStatus, MaterialDesign.MDI_MINUS_CIRCLE_OUTLINE, "unknown-result-label-large");
        } else if (result == EvalResult.PASSED) {
            IconMaker.updateLabelIcon(this.evalStatus, MaterialDesign.MDI_CHECK_CIRCLE_OUTLINE, "success-result-label-large");
        } else if (result == EvalResult.FAILED) {
            IconMaker.updateLabelIcon(this.evalStatus, MaterialDesign.MDI_CLOSE_CIRCLE_OUTLINE, "failure-result-label-large");
        } else if (result == EvalResult.UNEVALUATED) {
            IconMaker.updateLabelIcon(this.evalStatus, MaterialDesign.MDI_CUBE_OUTLINE, "box-icon-label-large");
        }
    }
}

