/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.question;

import java.util.Collections;
import java.util.function.IntFunction;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.QuestionController;
import tarski.core.controller.WorldController;
import tarski.gui.Tarski;
import tarski.gui.common.ContextMenuMaker;
import tarski.gui.common.GlobalSettings;
import tarski.gui.common.IconMaker;
import tarski.gui.question.ParserUpdateService;
import tarski.gui.question.QuestionBox;
import tarski.gui.question.WorldToolBar;
import tarski.gui.world.UIWorld;

public class QuestionWindow
extends BorderPane {
    private QuestionController questionController;
    private transient UIWorld uiWorld;
    private transient VirtualizedScrollPane<CodeArea> codeAreaScrollPane;
    private WorldToolBar toolbar;
    private ParserUpdateService parserUpdateService;
    private SplitPane centerPane;
    private EventHandler<KeyEvent> keyBoardShortCutHandler;

    public QuestionWindow(QuestionController questionController) {
        this.questionController = questionController;
        this.setPadding(new Insets(5.0, 5.0, 0.0, 0.0));
        this.toolbar = new WorldToolBar(questionController);
        this.codeAreaScrollPane = this.createFormulaEditor();
        this.setCenter(this.codeAreaScrollPane);
        this.codeAreaScrollPane.getContent().textProperty().addListener((observable, oldValue, newValue) -> questionController.setFormulaText((String)newValue));
        this.parserUpdateService = new ParserUpdateService(this.codeAreaScrollPane.getContent(), questionController);
        this.parserUpdateService.start();
        VBox topVBox = new VBox();
        QuestionBox questionBox = new QuestionBox(questionController);
        topVBox.setSpacing(5.0);
        topVBox.getChildren().addAll((Node[])new Node[]{this.toolbar, questionBox});
        this.setTop(topVBox);
        this.setupKeyboardShortcuts();
        this.codeAreaScrollPane.getContent().setStyle("-fx-font-size:" + GlobalSettings.editorTextSize + "pt !important;");
    }

    public QuestionWindow(QuestionController questionController, WorldController world) {
        this(questionController);
        this.showWorld(world);
    }

    public void clearRessources() {
        this.parserUpdateService.unSubscribe();
        Tarski.getScene().removeEventFilter(KeyEvent.KEY_PRESSED, this.keyBoardShortCutHandler);
    }

    public void showWorld(WorldController world) {
        this.uiWorld = new UIWorld(world);
        BorderPane.setMargin(this.uiWorld, new Insets(0.0, 0.0, 0.0, 5.0));
        this.toolbar.setWorld(world);
        this.centerPane = new SplitPane();
        this.centerPane.getItems().addAll((Node[])new Node[]{this.codeAreaScrollPane, this.uiWorld});
        this.setCenter(this.centerPane);
        Platform.runLater(() -> {
            this.centerPane.setDividerPositions(0.47);
            if (!(UIWorld.WORLD_SIZE.getValue() > 0.0)) {
                this.centerPane.setDividerPositions(0.2);
            }
        });
    }

    public VirtualizedScrollPane<CodeArea> createFormulaEditor() {
        String formulaText = this.questionController.getFormulaText();
        CodeArea codeAreaBox = formulaText != null ? new CodeArea(formulaText) : new CodeArea();
        MenuItem formatCode = new MenuItem("Format (Ctrl+Shift+F)", IconMaker.makeIconLabel(MaterialDesign.MDI_FORMAT_PAINT));
        formatCode.setOnAction(event -> this.formatCode());
        codeAreaBox.setContextMenu(ContextMenuMaker.makeContextMenu(Collections.singletonList(formatCode)));
        IntFunction<Node> lineNumberFactory = LineNumberFactory.get(codeAreaBox);
        codeAreaBox.setParagraphGraphicFactory(lineNumberFactory);
        this.codeAreaScrollPane = new VirtualizedScrollPane<CodeArea>(codeAreaBox, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.AS_NEEDED);
        return this.codeAreaScrollPane;
    }

    public CodeArea getCodeArea() {
        return this.codeAreaScrollPane.getContent();
    }

    public void showEditorView() {
        this.setCenter(this.codeAreaScrollPane);
        this.setRight(null);
        this.toolbar.showFormulaOnlyView();
    }

    public void setupKeyboardShortcuts() {
        this.keyBoardShortCutHandler = new EventHandler<KeyEvent>(){
            final KeyCombination keyComb = new KeyCodeCombination(KeyCode.F, KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN);

            @Override
            public void handle(KeyEvent ke) {
                if (this.keyComb.match(ke)) {
                    QuestionWindow.this.formatCode();
                    ke.consume();
                }
            }
        };
        Tarski.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this.keyBoardShortCutHandler);
        this.codeAreaScrollPane.addEventFilter(ScrollEvent.ANY, (? super T event) -> {
            if (event.isControlDown()) {
                GlobalSettings.editorTextSize = event.getDeltaY() > 0.0 ? ++GlobalSettings.editorTextSize : --GlobalSettings.editorTextSize;
                this.codeAreaScrollPane.getContent().setStyle("-fx-font-size:" + GlobalSettings.editorTextSize + "pt !important;");
            }
        });
    }

    private void formatCode() {
        String formattedText = this.questionController.getFormattedText();
        if (!formattedText.contentEquals("")) {
            this.codeAreaScrollPane.getContent().replaceText(formattedText);
            this.questionController.parseFormula();
            this.parserUpdateService.refreshStyling();
        }
    }
}

