/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.question;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.stage.Popup;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.reactfx.Subscription;
import tarski.core.controller.QuestionController;
import tarski.core.parser.ErrorType;
import tarski.core.parser.ParseError;
import tarski.core.parser.TokenHighlight;
import tarski.core.parser.TokenType;
import tarski.gui.Tarski;

public class ParserUpdateService {
    private CodeArea codeArea;
    private QuestionController questionController;
    private Subscription subscriptionService;
    private List<ParseError> errors;
    private List<TokenHighlight> tokenHighlights;

    public ParserUpdateService(CodeArea codeArea, QuestionController questionController) {
        this.codeArea = codeArea;
        this.questionController = questionController;
        this.setupToolTips();
    }

    public void unSubscribe() {
        this.subscriptionService.unsubscribe();
    }

    public void start() {
        this.subscriptionService = this.codeArea.multiPlainChanges().successionEnds(Duration.ofMillis(250L)).subscribe(change -> this.refreshStyling());
        this.refreshStyling();
    }

    public void refreshStyling() {
        this.codeArea.setStyleSpans(0, this.mergeStyleSpans(this.computeErrorUnderlining(), this.computeHighlighting()));
    }

    private StyleSpans<Collection<String>> computeErrorUnderlining() {
        this.questionController.parseFormula();
        this.errors = this.questionController.getParseErrors();
        String styleClass = "error-underline";
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        int lastKwEnd = 0;
        for (ParseError error : this.errors) {
            styleClass = error.getErrorType().equals((Object)ErrorType.SEMANTIC) ? "warning-underline" : "error-underline";
            spansBuilder.add(Collections.emptyList(), error.getStart() - lastKwEnd);
            if (error.getStart() == error.getStop()) {
                spansBuilder.add(Collections.singleton(styleClass), 1);
                lastKwEnd = error.getStop() + 1;
                continue;
            }
            spansBuilder.add(Collections.singleton(styleClass), error.getStop() - error.getStart());
            lastKwEnd = error.getStop();
        }
        if (this.errors.isEmpty()) {
            spansBuilder.add(Collections.emptyList(), this.codeArea.getText().length());
        }
        return spansBuilder.create();
    }

    private StyleSpans<Collection<String>> computeHighlighting() {
        this.questionController.parseFormula();
        this.tokenHighlights = this.questionController.getTokenHighlights();
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        int lastKwEnd = 0;
        for (TokenHighlight highlight : this.tokenHighlights) {
            String styleClass = this.getStyleClassFromTokenType(highlight.getType());
            spansBuilder.add(Collections.emptyList(), highlight.getStart() - lastKwEnd);
            if (highlight.getStart() == highlight.getStop()) {
                spansBuilder.add(Collections.singleton(styleClass), 1);
                lastKwEnd = highlight.getStop() + 1;
                continue;
            }
            spansBuilder.add(Collections.singleton(styleClass), highlight.getStop() - highlight.getStart());
            lastKwEnd = highlight.getStop();
        }
        if (this.tokenHighlights.isEmpty()) {
            spansBuilder.add(Collections.emptyList(), this.codeArea.getText().length());
        }
        return spansBuilder.create();
    }

    private String getStyleClassFromTokenType(TokenType type) {
        String ret = "";
        switch (type) {
            case UNARY_PREDICATE: {
                ret = "unary-predicate";
                break;
            }
            case BINARY_PREDICATE: {
                ret = "binary-predicate";
                break;
            }
            case TERNARY_PREDICATE: {
                ret = "ternary-predicate";
                break;
            }
            case COMMENT: {
                ret = "comment";
                break;
            }
            case QUANTIFIER: {
                ret = "quantifier";
                break;
            }
            case QUANTIFIER_VARIABLE: {
                ret = "quantifier-variable";
                break;
            }
            case REGULAR: {
                break;
            }
        }
        return ret;
    }

    private StyleSpans<Collection<String>> mergeStyleSpans(StyleSpans<Collection<String>> first, StyleSpans<Collection<String>> second) {
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        int firstStyleSpanIndex = 0;
        int secondStyleSpanIndex = 0;
        int firstStyleSpanDistance = 0;
        int secondStyleSpanDistance = 0;
        if (first.getSpanCount() > 0) {
            firstStyleSpanDistance = first.getStyleSpan(firstStyleSpanIndex).getLength();
        }
        if (second.getSpanCount() > 0) {
            secondStyleSpanDistance = second.getStyleSpan(secondStyleSpanIndex).getLength();
        }
        for (int i = 0; i < this.codeArea.getText().length(); ++i) {
            Collection<Object> secondStyles;
            Collection<Object> firstStyles;
            if (first.getSpanCount() > 0) {
                if (i >= firstStyleSpanDistance) {
                    if (first.getSpanCount() > firstStyleSpanIndex + 1) {
                        firstStyleSpanDistance += first.getStyleSpan(++firstStyleSpanIndex).getLength();
                        firstStyles = first.getStyleSpan(firstStyleSpanIndex).getStyle();
                    } else {
                        firstStyles = Collections.emptyList();
                    }
                } else {
                    firstStyles = first.getStyleSpan(firstStyleSpanIndex).getStyle();
                }
            } else {
                firstStyles = Collections.emptyList();
            }
            if (second.getSpanCount() > 0) {
                if (i >= secondStyleSpanDistance) {
                    if (second.getSpanCount() > secondStyleSpanIndex + 1) {
                        secondStyleSpanDistance += second.getStyleSpan(++secondStyleSpanIndex).getLength();
                        secondStyles = second.getStyleSpan(secondStyleSpanIndex).getStyle();
                    } else {
                        secondStyles = Collections.emptyList();
                    }
                } else {
                    secondStyles = second.getStyleSpan(secondStyleSpanIndex).getStyle();
                }
            } else {
                secondStyles = Collections.emptyList();
            }
            List combinedStream = Stream.concat(firstStyles.stream(), secondStyles.stream()).collect(Collectors.toList());
            if (combinedStream.isEmpty()) {
                spansBuilder.add(Collections.emptyList(), 1);
                continue;
            }
            spansBuilder.add(combinedStream, 1);
        }
        if (this.codeArea.getText().length() <= 0) {
            spansBuilder.add(Collections.emptyList(), this.codeArea.getText().length());
        }
        return spansBuilder.create();
    }

    public void updateParserService(CodeArea codeArea, QuestionController questionController) {
        this.codeArea = codeArea;
        this.questionController = questionController;
        this.setupToolTips();
        if (codeArea.getText().length() > 1) {
            this.refreshStyling();
        }
    }

    private void setupToolTips() {
        Popup popup = new Popup();
        Label popupMsg = new Label();
        popupMsg.getStylesheets().add(Tarski.class.getResource("main.css").toExternalForm());
        popupMsg.getStyleClass().add("popup-error-tooltip");
        popup.getContent().add(popupMsg);
        this.codeArea.setMouseOverTextDelay(Duration.ofMillis(500L));
        this.codeArea.addEventHandler(MouseOverTextEvent.MOUSE_OVER_TEXT_BEGIN, e -> {
            int chIdx = e.getCharacterIndex();
            Point2D pos = e.getScreenPosition();
            Boolean isSet = false;
            for (ParseError error : this.errors) {
                int start = error.getStart();
                int stop = error.getStop();
                if (chIdx < start || chIdx > stop) continue;
                popupMsg.setText(error.getMsg());
                popupMsg.setVisible(true);
                isSet = true;
                break;
            }
            if (!isSet.booleanValue()) {
                popupMsg.setVisible(false);
            }
            popup.show(this.codeArea, pos.getX(), pos.getY() + 10.0);
        });
        this.codeArea.addEventHandler(MouseOverTextEvent.MOUSE_OVER_TEXT_END, e -> popup.hide());
    }
}

