/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.controller;

import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.gui.Tarski;
import tarski.gui.common.IconMaker;

public abstract class TarskiWindowController {
    protected Stage stage;
    public Boolean isMaximized = false;
    private double windowWidth;
    private double windowHeight;
    private double windowPosX;
    private double windowPosY;
    protected boolean isPrimaryStage = false;
    @FXML
    protected BorderPane mainBorderPane;
    @FXML
    protected Button closeButton;
    @FXML
    protected Button minimizeButton;
    @FXML
    protected Button maximizeButton;
    @FXML
    private VBox topVbox;
    @FXML
    private AnchorPane windowToolBar;
    @FXML
    private Label footerLabel;

    public void setStage(Stage primaryStage) {
        this.stage = primaryStage;
        this.closeButton.setPadding(Insets.EMPTY);
        this.minimizeButton.setPadding(Insets.EMPTY);
        this.maximizeButton.setPadding(Insets.EMPTY);
        this.setupFooter(this.footerLabel);
    }

    @FXML
    public void handleCloseButtonAction(MouseEvent event) {
        if (this.isPrimaryStage) {
            Tarski.closeProgram();
        } else {
            this.stage.close();
        }
    }

    @FXML
    public void handleMinimiseButtonAction(MouseEvent event) {
        this.stage.setIconified(true);
    }

    @FXML
    public void handleMaximizeButtonAction(MouseEvent event) {
        if (this.stage.isMaximized()) {
            this.restoreWindow();
            this.restoreWindowPosition();
        } else {
            this.maximizeWindow();
        }
    }

    public abstract void setupCodeDrivenUi(Controller<?> var1);

    public abstract void setupFooter(Label var1);

    public void restoreWindow() {
        this.stage.setMaximized(false);
        this.maximizeButton.setGraphic(IconMaker.makeIcon(MaterialDesign.MDI_WINDOW_MAXIMIZE, "title_bar_button"));
        this.restoreWindowDimensions();
    }

    public void maximizeWindow() {
        this.maximizeButton.setGraphic(IconMaker.makeIcon(MaterialDesign.MDI_WINDOW_RESTORE, "title_bar_button"));
        this.setOldWindowDimension();
        this.setOldWindowPosition();
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        this.stage.setX(bounds.getMinX());
        this.stage.setY(bounds.getMinY());
        this.stage.setWidth(bounds.getWidth());
        this.stage.setHeight(bounds.getHeight());
        this.stage.setMaximized(true);
    }

    public void restoreWindowDimensions() {
        this.stage.setWidth(this.windowWidth);
        this.stage.setHeight(this.windowHeight);
    }

    public void restoreWindowPosition() {
        this.stage.setX(this.windowPosX);
        this.stage.setY(this.windowPosY);
    }

    public void setOldWindowDimension() {
        Scene scene = this.stage.getScene();
        this.windowHeight = scene.getHeight();
        this.windowWidth = scene.getWidth();
    }

    public void setOldWindowPosition() {
        this.windowPosX = this.stage.getX();
        this.windowPosY = this.stage.getY();
    }

    public void hideWindowsMenuBar() {
        this.topVbox.getChildren().remove(this.windowToolBar);
    }
}

