/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTreeView;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import tarski.core.controller.Controller;
import tarski.core.controller.DataController;
import tarski.gui.Tarski;
import tarski.gui.common.AlertMaker;
import tarski.gui.common.GlobalSettings;
import tarski.gui.common.IconMaker;
import tarski.gui.common.Logger;
import tarski.gui.controller.TarskiWindowController;
import tarski.gui.textpages.WelcomePage;
import tarski.gui.treeview.FormulaTreeManager;

public class TarskiMainController
extends TarskiWindowController {
    private DataController dataController;
    private FormulaTreeManager formulaTreeManager;
    private EventHandler<KeyEvent> keyboardShortCuthandler;
    @FXML
    private StackPane rootStackPane;
    @FXML
    private BorderPane windowBar;
    @FXML
    private JFXButton addTabButton;
    @FXML
    private HBox formulaHbox;
    @FXML
    private JFXTreeView<String> formulaTreeView;
    @FXML
    private AnchorPane windowToolBar;
    @FXML
    private TextArea tarskiLog;
    @FXML
    private TextArea parserLog;
    @FXML
    private TextArea evalLog;
    @FXML
    private AnchorPane logTabAnchorPane;
    @FXML
    private TabPane logTabPane;
    @FXML
    private Menu borderMenuItemView;
    @FXML
    private Menu fileMenu;
    @FXML
    private Menu helpMenu;
    @FXML
    private VBox topVbox;
    @FXML
    private SplitPane mainHSplitPane;
    @FXML
    private SplitPane mainVSplitPane;
    @FXML
    private AnchorPane editorPane;
    @FXML
    private AnchorPane treeViewAnchorPane;
    @FXML
    private BorderPane mainBorderPane;

    public void menuCloseAction(ActionEvent event) {
        Tarski.closeProgram();
    }

    public void saveProjectAction(ActionEvent event) {
        String fileName = GlobalSettings.getOpenProjectFileName();
        if (fileName.isEmpty()) {
            this.saveAsProjectAction(event);
            return;
        }
        try {
            ObjectMapper om = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            ObjectNode root = this.dataController.toJson(om, null);
            File validatedFile = new File(fileName);
            om.writeValue(validatedFile, (Object)root);
            fileName = validatedFile.toString();
            GlobalSettings.resetLastChangeSetting();
            Logger.getLogger().tarskiLog("Data exported to " + fileName);
        }
        catch (Exception e) {
            Logger.getLogger().tarskiLog("Error while writing to " + fileName + "\n" + e.toString());
        }
    }

    public void saveAsProjectAction(ActionEvent event) {
        String fileName = "default.json";
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialDirectory(new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()));
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("JSON files (*.json)", "*.json");
            fileChooser.getExtensionFilters().add(extFilter);
            File selectedFile = fileChooser.showSaveDialog(this.stage);
            if (selectedFile == null) {
                Logger.getLogger().tarskiLog("Error no file was specified.");
                return;
            }
            File validatedFile = this.validateJsonFileName(selectedFile);
            ObjectMapper om = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
            ObjectNode root = this.dataController.toJson(om, null);
            om.writeValue(validatedFile, (Object)root);
            fileName = validatedFile.toString();
            GlobalSettings.resetLastChangeSetting();
            GlobalSettings.saveOpenedProject(fileName);
            Logger.getLogger().tarskiLog("Data exported to " + fileName);
        }
        catch (Exception e) {
            Logger.getLogger().tarskiLog("Error while writing to " + fileName + "\n" + e.toString());
        }
    }

    private File validateJsonFileName(File file) {
        Object fileName = file.getName();
        if (!((String)fileName).endsWith(".json")) {
            fileName = (String)fileName + ".json";
            File newFileName = new File((String)fileName);
            file.renameTo(newFileName);
        }
        return file;
    }

    public void newProjectAction(ActionEvent event) {
        JFXButton yesButton = new JFXButton("Yes");
        JFXButton cancelButton = new JFXButton("Cancel");
        yesButton.setOnAction(yesButtonEvent -> {
            GlobalSettings.resetProjectFileName();
            this.formulaTreeManager.showDefaultView();
            Platform.runLater(() -> this.formulaTreeManager.clearAllFormulas());
        });
        AlertMaker.showMaterialDialog(Arrays.asList(yesButton, cancelButton), "Confirm removal", "Are you sure you want to delete all formulas? This action is permanent and cannot be undone.");
    }

    public void importProjectAction(ActionEvent event) {
        String fileName = "default.json";
        ObjectMapper om = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        GlobalSettings.resetProjectFileName();
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialDirectory(new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()));
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("JSON files (*.json)", "*.json");
            fileChooser.getExtensionFilters().add(extFilter);
            File selectedFile = fileChooser.showOpenDialog(this.stage);
            if (selectedFile == null) {
                return;
            }
            DataController newController = new DataController(om.readTree(selectedFile), null);
            this.setDataController(newController);
            fileName = selectedFile.toString();
            GlobalSettings.resetLastChangeSetting();
            GlobalSettings.saveOpenedProject(fileName);
            Logger.getLogger().tarskiLog("Data imported from " + fileName);
        }
        catch (Exception e) {
            Logger.getLogger().tarskiLog("Error while reading " + fileName + "\n" + e.toString());
        }
    }

    public void importTestWorldsAction(ActionEvent event) {
        String fileName = "default.json";
        try {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialDirectory(new File(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()));
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("JSON files (*.json)", "*.json");
            fileChooser.getExtensionFilters().add(extFilter);
            File selectedFile = fileChooser.showOpenDialog(this.stage);
            if (selectedFile != null) {
                fileName = selectedFile.toString();
                ObjectMapper om = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
                JsonNode node = om.readTree(selectedFile);
                this.dataController.importTestWorldsFromFile(node);
                this.setDataController(this.dataController);
                this.resetView();
                GlobalSettings.resetLastChangeSetting();
                Logger.getLogger().tarskiLog("Data imported from " + fileName);
            }
        }
        catch (Exception e) {
            Logger.getLogger().tarskiLog("Error while reading " + fileName + "\n" + e.toString());
        }
    }

    @Override
    public void setupCodeDrivenUi(Controller<?> dataController) {
        this.isPrimaryStage = true;
        this.dataController = (DataController)dataController;
        this.formulaTreeManager = new FormulaTreeManager(this.dataController, this.editorPane);
        Logger.setInstance(this.tarskiLog, this.parserLog, this.evalLog);
        this.resetView();
        AlertMaker.setupAlertMaker(this.rootStackPane, this.mainBorderPane);
        MenuItem newProject = new MenuItem("New project", IconMaker.makeIconLabel(MaterialDesign.MDI_OPEN_IN_NEW));
        MenuItem openProject = new MenuItem("Open project", IconMaker.makeIconLabel(MaterialDesign.MDI_IMPORT));
        MenuItem importTestWorlds = new MenuItem("Import Test Worlds", IconMaker.makeIconLabel(MaterialDesign.MDI_TEST_TUBE));
        MenuItem saveProject = new MenuItem("Save", IconMaker.makeIconLabel(MaterialDesign.MDI_CONTENT_SAVE));
        MenuItem saveAsProject = new MenuItem("Save as", IconMaker.makeIconLabel(MaterialDesign.MDI_EXPORT));
        MenuItem exit = new MenuItem("Exit", IconMaker.makeIconLabel(MaterialDesign.MDI_CLOSE));
        MenuItem manual = new MenuItem("Manual", IconMaker.makeIconLabel(MaterialDesign.MDI_BOOK_OPEN_VARIANT));
        CheckMenuItem logPanelToggle = new CheckMenuItem("Show log panel");
        newProject.setOnAction(this::newProjectAction);
        openProject.setOnAction(this::importProjectAction);
        importTestWorlds.setOnAction(this::importTestWorldsAction);
        saveProject.setOnAction(this::saveProjectAction);
        saveAsProject.setOnAction(this::saveAsProjectAction);
        exit.setOnAction(this::menuCloseAction);
        manual.setOnAction(event -> {
            block14: {
                try {
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        URL ressource = this.getClass().getResource("/tarski/gui/manual.html");
                        if (ressource != null) {
                            File tempFile = File.createTempFile("tempHtml", ".html");
                            tempFile.deleteOnExit();
                            try (InputStream in = ressource.openStream();){
                                Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                EventQueue.invokeLater(() -> {
                                    try {
                                        Desktop.getDesktop().browse(tempFile.toURI());
                                    }
                                    catch (IOException e) {
                                        this.showBrowserOpenError();
                                    }
                                });
                                break block14;
                            }
                            catch (IOException e) {
                                this.showBrowserOpenError();
                            }
                            break block14;
                        }
                        Desktop.getDesktop().browse(new File("manual.html").toURI());
                        break block14;
                    }
                    this.showBrowserOpenError();
                }
                catch (MalformedURLException e) {
                    this.showBrowserOpenError();
                }
                catch (IOException e) {
                    this.showBrowserOpenError();
                }
                catch (Exception e) {
                    this.showBrowserOpenError();
                }
            }
        });
        this.fileMenu.getItems().addAll((MenuItem[])new MenuItem[]{newProject, openProject, importTestWorlds, new SeparatorMenuItem(), saveProject, saveAsProject, new SeparatorMenuItem(), exit});
        this.helpMenu.getItems().add(manual);
        logPanelToggle.setSelected(true);
        this.borderMenuItemView.getItems().add(logPanelToggle);
        logPanelToggle.setOnAction(event -> {
            if (logPanelToggle.isSelected()) {
                this.mainVSplitPane.getItems().remove(1);
                this.mainVSplitPane.getItems().add(1, this.logTabAnchorPane);
                this.mainVSplitPane.setDividerPositions(0.75);
            } else {
                VBox spacingVBox = new VBox();
                this.mainVSplitPane.getItems().remove(1);
                spacingVBox.setMinHeight(5.0);
                spacingVBox.setMaxHeight(5.0);
                this.mainVSplitPane.getItems().add(1, spacingVBox);
                this.mainVSplitPane.setDividerPositions(0.77);
            }
        });
        this.setupKeyboardShortcuts();
        GlobalSettings.resetLastChangeSetting();
    }

    private void showBrowserOpenError() {
        JFXButton ok = new JFXButton("Ok");
        AlertMaker.showMaterialDialog(Arrays.asList(ok), "Unable to open browser", "The browser cannot be opened. To view the manual, open bin/manual.html in your browser. We apologize for the inconvenience.");
    }

    private void setupKeyboardShortcuts() {
        this.keyboardShortCuthandler = new EventHandler<KeyEvent>(){
            final KeyCombination evalKeyCombination = new KeyCodeCombination(KeyCode.R, KeyCombination.CONTROL_DOWN);

            @Override
            public void handle(KeyEvent ke) {
                if (this.evalKeyCombination.match(ke)) {
                    TarskiMainController.this.dataController.evalAll();
                }
            }
        };
        Tarski.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this.keyboardShortCuthandler);
    }

    public void setSplitPaneDividerRatios() {
        this.mainHSplitPane.setDividerPositions(0.15);
        this.mainVSplitPane.setDividerPositions(0.77);
    }

    public void appendText(String valueOf) {
        Platform.runLater(() -> this.tarskiLog.appendText(valueOf));
    }

    public void setDataController(DataController dataController) {
        this.clearRessources();
        this.dataController = dataController;
        this.formulaTreeManager = new FormulaTreeManager(dataController, this.editorPane);
        this.resetView();
    }

    private void resetView() {
        this.showWelcomeView();
        this.showTreeView(this.formulaTreeManager.getTreeViewPane());
        this.setupKeyboardShortcuts();
    }

    private void clearRessources() {
        Tarski.getScene().removeEventFilter(KeyEvent.KEY_PRESSED, this.keyboardShortCuthandler);
        this.formulaTreeManager.clearRessources();
    }

    public void showTreeView(Pane treeView) {
        this.treeViewAnchorPane.getChildren().clear();
        AnchorPane.setTopAnchor(treeView, 0.0);
        AnchorPane.setBottomAnchor(treeView, 0.0);
        AnchorPane.setLeftAnchor(treeView, 0.0);
        AnchorPane.setRightAnchor(treeView, 0.0);
        this.treeViewAnchorPane.getChildren().add(treeView);
        this.treeViewAnchorPane.setMaxWidth(230.0);
    }

    public void showWelcomeView() {
        WelcomePage welcomePage = new WelcomePage();
        this.editorPane.getChildren().clear();
        AnchorPane.setTopAnchor(welcomePage, 5.0);
        AnchorPane.setBottomAnchor(welcomePage, 0.0);
        AnchorPane.setLeftAnchor(welcomePage, 0.0);
        AnchorPane.setRightAnchor(welcomePage, 5.0);
        this.editorPane.getChildren().add(welcomePage);
    }

    @Override
    public void maximizeWindow() {
        this.maximizeButton.setGraphic(IconMaker.makeIcon(MaterialDesign.MDI_WINDOW_RESTORE, "title_bar_button"));
        this.setOldWindowDimension();
        this.setOldWindowPosition();
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        this.stage.setX(bounds.getMinX());
        this.stage.setY(bounds.getMinY());
        this.stage.setWidth(bounds.getWidth());
        this.stage.setHeight(bounds.getHeight());
        this.stage.setMaximized(true);
        this.setSplitPaneDividerRatios();
    }

    @Override
    public void setupFooter(Label footerLabel) {
        footerLabel.setText("v" + GlobalSettings.getProjectVersion());
    }
}

