/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.controller;

import javafx.application.Platform;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.text.Text;
import tarski.core.controller.Controller;
import tarski.core.controller.QuestionController;
import tarski.core.formula.FormulaEvalResult;
import tarski.gui.Tarski;
import tarski.gui.common.GlobalSettings;
import tarski.gui.controller.TarskiWindowController;

public class DebugWindowController
extends TarskiWindowController {
    private QuestionController questionController;

    @Override
    public void setupCodeDrivenUi(Controller<?> controller) {
        this.questionController = (QuestionController)controller;
        this.mainBorderPane.getStyleClass().add("border-pane");
        TreeTableView<FormulaEvalResult> treeTableView = new TreeTableView<FormulaEvalResult>();
        treeTableView.setColumnResizePolicy(param -> true);
        treeTableView.getStylesheets().add(Tarski.class.getResource("debug-window.css").toExternalForm());
        TreeTableColumn<FormulaEvalResult, String> formulaColumn = new TreeTableColumn<FormulaEvalResult, String>("Formula");
        TreeTableColumn resultColumn = new TreeTableColumn("Result");
        formulaColumn.setCellValueFactory(formulaBlockEvalResult -> {
            TreeItem item = formulaBlockEvalResult.getValue();
            FormulaEvalResult evalResult = (FormulaEvalResult)item.getValue();
            return evalResult.formulaTextProperty();
        });
        resultColumn.setCellValueFactory(formulaBlockEvalResult -> {
            TreeItem item = formulaBlockEvalResult.getValue();
            FormulaEvalResult evalResult = (FormulaEvalResult)item.getValue();
            return evalResult.resultProperty();
        });
        treeTableView.getColumns().add(formulaColumn);
        treeTableView.getColumns().add(resultColumn);
        TreeItem<FormulaEvalResult> root = this.setupTreeTableView(this.questionController.getFormula().getFormulaEvalResult());
        treeTableView.setRoot(root);
        this.mainBorderPane.setCenter(treeTableView);
        this.fitColumnWidthToContent(treeTableView, formulaColumn);
        Platform.runLater(() -> {
            if (treeTableView.getWidth() > 600.0) {
                this.stage.setWidth(treeTableView.getWidth() + 100.0);
            } else {
                this.stage.setWidth(600.0);
            }
            this.stage.setMinWidth(300.0);
        });
    }

    public TreeItem<FormulaEvalResult> setupTreeTableView(FormulaEvalResult formulaEvalResult) {
        TreeItem<FormulaEvalResult> rootFormulaItem = new TreeItem<FormulaEvalResult>(formulaEvalResult);
        for (FormulaEvalResult result : formulaEvalResult.getResults()) {
            TreeItem<FormulaEvalResult> subTreeItem = this.setupTreeTableView(result);
            rootFormulaItem.getChildren().add(subTreeItem);
        }
        return rootFormulaItem;
    }

    private void fitColumnWidthToContent(TreeTableView<FormulaEvalResult> treeView, TreeTableColumn<FormulaEvalResult, String> column) {
        double max = this.getMaxTextLength(treeView.getRoot(), 20.0);
        column.setPrefWidth(max + 100.0);
    }

    private double getMaxTextLength(TreeItem<FormulaEvalResult> treeItem, double arrowIndent) {
        Text text = new Text(treeItem.getValue().formulaTextProperty().getValue());
        double max = text.getLayoutBounds().getWidth();
        for (TreeItem treeItem2 : treeItem.getChildren()) {
            double eachMax = this.getMaxTextLength(treeItem2, arrowIndent + 20.0) + arrowIndent;
            if (!(eachMax > max)) continue;
            max = eachMax;
        }
        return max;
    }

    @Override
    public void setupFooter(Label footerLabel) {
        footerLabel.setText("v" + GlobalSettings.getProjectVersion() + " (debug)");
    }
}

