/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class ResizeHelper {
    static boolean isDragging = false;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static void addResizeListener(Stage stage) {
        ResizeHelper.addResizeListener(stage, 1.0, 1.0, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    public static void addResizeListener(Stage stage, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        ResizeListener resizeListener = new ResizeListener(stage);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_MOVED, resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_PRESSED, resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_DRAGGED, resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED, resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, resizeListener);
        stage.getScene().addEventHandler(MouseEvent.MOUSE_RELEASED, resizeListener);
        resizeListener.setMinWidth(minWidth);
        resizeListener.setMinHeight(minHeight);
        resizeListener.setMaxWidth(maxWidth);
        resizeListener.setMaxHeight(maxHeight);
        ObservableList<Node> children = stage.getScene().getRoot().getChildrenUnmodifiable();
        for (Node child : children) {
            ResizeHelper.addListenerDeeply(child, resizeListener);
        }
    }

    private static void addListenerDeeply(Node node, EventHandler<MouseEvent> listener) {
        node.addEventHandler(MouseEvent.MOUSE_MOVED, listener);
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, listener);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, listener);
        node.addEventHandler(MouseEvent.MOUSE_EXITED, listener);
        node.addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, listener);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, listener);
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            ObservableList<Node> children = parent.getChildrenUnmodifiable();
            for (Node child : children) {
                ResizeHelper.addListenerDeeply(child, listener);
            }
        }
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    static class ResizeListener
    implements EventHandler<MouseEvent> {
        private Stage stage;
        private Cursor cursorEvent = Cursor.DEFAULT;
        private boolean resizing = true;
        private int border = 4;
        private double startX = 0.0;
        private double startY = 0.0;
        private double screenOffsetX = 0.0;
        private double screenOffsetY = 0.0;
        private double windowBarHeight = 25.0;
        private double minWidth;
        private double maxWidth;
        private double minHeight;
        private double maxHeight;

        public ResizeListener(Stage stage) {
            this.stage = stage;
        }

        public void setMinWidth(double minWidth) {
            this.minWidth = minWidth;
        }

        public void setMaxWidth(double maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setMinHeight(double minHeight) {
            this.minHeight = minHeight;
        }

        public void setMaxHeight(double maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public void handle(MouseEvent mouseEvent) {
            EventType<? extends MouseEvent> mouseEventType = mouseEvent.getEventType();
            Scene scene = this.stage.getScene();
            double mouseEventX = mouseEvent.getSceneX();
            double mouseEventY = mouseEvent.getSceneY();
            double sceneWidth = scene.getWidth();
            double sceneHeight = scene.getHeight();
            if (MouseEvent.MOUSE_MOVED.equals(mouseEventType) && !this.stage.isMaximized()) {
                this.cursorEvent = mouseEventX < (double)this.border && mouseEventY < (double)this.border ? Cursor.NW_RESIZE : (mouseEventX < (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SW_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY < (double)this.border ? Cursor.NE_RESIZE : (mouseEventX > sceneWidth - (double)this.border && mouseEventY > sceneHeight - (double)this.border ? Cursor.SE_RESIZE : (mouseEventX < (double)this.border ? Cursor.W_RESIZE : (mouseEventX > sceneWidth - (double)this.border ? Cursor.E_RESIZE : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT)))))));
                scene.setCursor(this.cursorEvent);
            } else if (MouseEvent.MOUSE_EXITED.equals(mouseEventType) || MouseEvent.MOUSE_EXITED_TARGET.equals(mouseEventType)) {
                scene.setCursor(Cursor.DEFAULT);
            } else if (MouseEvent.MOUSE_PRESSED.equals(mouseEventType)) {
                this.startX = this.stage.getWidth() - mouseEventX;
                this.startY = this.stage.getHeight() - mouseEventY;
            } else if (MouseEvent.MOUSE_DRAGGED.equals(mouseEventType) && !this.stage.isMaximized() && !Cursor.DEFAULT.equals(this.cursorEvent)) {
                this.resizing = true;
                if (!Cursor.W_RESIZE.equals(this.cursorEvent) && !Cursor.E_RESIZE.equals(this.cursorEvent)) {
                    double minHeight;
                    double d = minHeight = this.stage.getMinHeight() > (double)(this.border * 2) ? this.stage.getMinHeight() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.N_RESIZE.equals(this.cursorEvent) || Cursor.NE_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getHeight() > minHeight || mouseEventY < 0.0) {
                            this.setStageHeight(this.stage.getY() - mouseEvent.getScreenY() + this.stage.getHeight());
                            this.stage.setY(mouseEvent.getScreenY());
                        }
                    } else if (this.stage.getHeight() > minHeight || mouseEventY + this.startY - this.stage.getHeight() > 0.0) {
                        this.setStageHeight(mouseEventY + this.startY);
                    }
                }
                if (!Cursor.N_RESIZE.equals(this.cursorEvent) && !Cursor.S_RESIZE.equals(this.cursorEvent)) {
                    double minWidth;
                    double d = minWidth = this.stage.getMinWidth() > (double)(this.border * 2) ? this.stage.getMinWidth() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.W_RESIZE.equals(this.cursorEvent) || Cursor.SW_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getWidth() > minWidth || mouseEventX < 0.0) {
                            this.setStageWidth(this.stage.getX() - mouseEvent.getScreenX() + this.stage.getWidth());
                            this.stage.setX(mouseEvent.getScreenX());
                        }
                    } else if (this.stage.getWidth() > minWidth || mouseEventX + this.startX - this.stage.getWidth() > 0.0) {
                        this.setStageWidth(mouseEventX + this.startX);
                    }
                }
                this.resizing = false;
            }
            if (MouseEvent.MOUSE_PRESSED.equals(mouseEventType) && Cursor.DEFAULT.equals(this.cursorEvent) && mouseEventY < this.windowBarHeight && mouseEventY > (double)this.border) {
                this.resizing = false;
                isDragging = true;
                this.screenOffsetX = this.stage.getX() - mouseEvent.getScreenX();
                this.screenOffsetY = this.stage.getY() - mouseEvent.getScreenY();
            }
            if (MouseEvent.MOUSE_DRAGGED.equals(mouseEventType) && Cursor.DEFAULT.equals(this.cursorEvent) && !this.resizing && isDragging && !this.stage.isMaximized()) {
                this.stage.setX(mouseEvent.getScreenX() + this.screenOffsetX);
                this.stage.setY(mouseEvent.getScreenY() + this.screenOffsetY);
            }
            if (MouseEvent.MOUSE_RELEASED.equals(mouseEventType) && Cursor.DEFAULT.equals(this.cursorEvent) && !this.resizing && isDragging) {
                isDragging = false;
            }
        }

        private void setStageWidth(double width) {
            width = Math.min(width, this.maxWidth);
            width = Math.max(width, this.minWidth);
            this.stage.setWidth(width);
        }

        private void setStageHeight(double height) {
            height = Math.min(height, this.maxHeight);
            height = Math.max(height, this.minHeight);
            this.stage.setHeight(height);
        }
    }
}

