/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javafx.application.Platform;
import javafx.scene.control.TextArea;

public class Logger {
    private static Logger loggerInstance = null;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("[HH:mm:ss]");
    private TextArea tarskiLog;
    private TextArea parserLog;
    private TextArea evalLog;

    private Logger(TextArea tarskiLog, TextArea parserLog, TextArea evalLog) {
        this.tarskiLog = tarskiLog;
        this.parserLog = parserLog;
        this.evalLog = evalLog;
    }

    public static Logger setInstance(TextArea tarskiLog, TextArea parserLog, TextArea evalLog) {
        loggerInstance = new Logger(tarskiLog, parserLog, evalLog);
        return loggerInstance;
    }

    public static Logger getLogger() {
        return loggerInstance;
    }

    public void rawLog(String logMessage) {
        Platform.runLater(() -> this.tarskiLog.appendText(logMessage));
    }

    public void tarskiLog(String logMessage) {
        this.log(this.tarskiLog, logMessage);
    }

    public void parserLog(String logMessage) {
        this.log(this.parserLog, logMessage);
    }

    public void evalLog(String source, String logMessage) {
        this.log(this.evalLog, source, logMessage);
    }

    private void log(TextArea log, String source, String logMessage) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Platform.runLater(() -> log.appendText(dateFormat.format(timestamp) + " [" + source + "] - " + logMessage + "\n"));
    }

    private void log(TextArea log, String logMessage) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Platform.runLater(() -> log.appendText(dateFormat.format(timestamp) + " - " + logMessage + "\n"));
    }
}

