/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import com.jfoenix.controls.JFXButton;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class IconMaker {
    public static Label makeIconLabel(MaterialDesign icon) {
        Label label = new Label();
        label.setGraphic(new FontIcon(icon));
        label.setId("menu-item-icon");
        label.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        return label;
    }

    public static Label makeIconLabelDanger(MaterialDesign icon) {
        Label label = new Label();
        label.setGraphic(new FontIcon(icon));
        label.setId("menu-item-icon-danger");
        label.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        return label;
    }

    public static Label makeIconLabel(MaterialDesign icon, String iconId) {
        Label label = new Label();
        label.setGraphic(new FontIcon(icon));
        label.setId(iconId);
        label.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        return label;
    }

    public static FontIcon makeIcon(MaterialDesign icon, String styleClass) {
        FontIcon ikon = new FontIcon(icon);
        ikon.getStyleClass().add(styleClass);
        return ikon;
    }

    public static JFXButton makeIconButton(MaterialDesign icon, String iconId) {
        JFXButton button = new JFXButton();
        button.setId(iconId);
        button.setGraphic(new FontIcon(icon));
        return button;
    }

    public static JFXButton makeIconButton(MaterialDesign icon, String iconId, String text) {
        JFXButton button = new JFXButton();
        Label label = new Label();
        label.setText(text);
        label.getStyleClass().add("button-label");
        HBox hbox = new HBox();
        hbox.setAlignment(Pos.CENTER);
        hbox.setSpacing(5.0);
        hbox.getChildren().addAll((Node[])new Node[]{label, new FontIcon(icon)});
        button.setId(iconId);
        button.setGraphic(hbox);
        return button;
    }

    public static Label updateLabelIcon(Label label, MaterialDesign icon, String iconId) {
        label.setGraphic(new FontIcon(icon));
        label.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        label.setId(iconId);
        return label;
    }
}

