/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import tarski.gui.Tarski;
import tarski.gui.common.Logger;

public class GlobalSettings {
    public static int editorTextSize = 15;
    private static String fileNameProject = "";
    private static boolean changedSinceLastSaved = true;

    public static void registerChange() {
        changedSinceLastSaved = true;
    }

    public static void resetLastChangeSetting() {
        changedSinceLastSaved = false;
    }

    public static boolean wasChangeSinceLastSave() {
        return changedSinceLastSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectVersion() {
        String result = "";
        InputStream inputStream = null;
        try {
            Properties prop = new Properties();
            String propFileName = "version.properties";
            inputStream = Tarski.class.getClassLoader().getResourceAsStream(propFileName);
            if (inputStream != null) {
                prop.load(inputStream);
            } else {
                Logger.getLogger().tarskiLog("property file '" + propFileName + "' not found in the classpath");
            }
            result = prop.getProperty("version");
        }
        catch (Exception e) {
            Logger.getLogger().tarskiLog(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Logger.getLogger().tarskiLog(e.getMessage());
                }
            }
        }
        return result;
    }

    public static String getOpenProjectFileName() {
        return fileNameProject;
    }

    public static void saveOpenedProject(String fileName) {
        fileNameProject = fileName;
    }

    public static void resetProjectFileName() {
        GlobalSettings.saveOpenedProject("");
    }
}

