/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import javafx.beans.InvalidationListener;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class ExpandingTextArea
extends TextArea {
    @Override
    protected void layoutChildren() {
        super.layoutChildren();
        this.setWrapText(true);
        this.addListenerToTextHeight();
        this.autoAdjustHeight(this.getTextObject());
    }

    private Text getTextObject() {
        ScrollPane scrollPane = (ScrollPane)this.lookup(".scroll-pane");
        StackPane viewport = (StackPane)scrollPane.lookup(".viewport");
        Region content = (Region)viewport.lookup(".content");
        return (Text)content.lookup(".text");
    }

    private void addListenerToTextHeight() {
        ScrollPane scrollPane = (ScrollPane)this.lookup(".scroll-pane");
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        Text text = this.getTextObject();
        text.textProperty().addListener(this.textHeightListener(text));
    }

    private InvalidationListener textHeightListener(Text text) {
        return property -> this.autoAdjustHeight(text);
    }

    private void autoAdjustHeight(Text text) {
        double textHeight = text.getBoundsInLocal().getHeight() + 13.0;
        if (textHeight < 40.0) {
            textHeight = 40.0;
        }
        this.setMinHeight(textHeight);
        this.setPrefHeight(textHeight);
        this.setMaxHeight(textHeight);
    }
}

