/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui.common;

import com.jfoenix.controls.JFXTextField;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;

public class EditableLabel
extends Label {
    protected JFXTextField textField;
    protected Boolean doucleClickEnabled = true;
    protected String oldText;
    protected boolean wasSetByAction;

    public EditableLabel() {
        this("");
    }

    public EditableLabel(String name) {
        this.setText(name);
        this.textField = new JFXTextField();
        this.getStyleClass().add("editable-label");
        this.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2 && event.getButton().equals((Object)MouseButton.PRIMARY) && this.doucleClickEnabled.booleanValue()) {
                this.openLabelEditor();
            }
        });
        this.textField.setOnAction(event -> this.parentTextUpdate());
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.parentTextUpdate();
            }
        });
    }

    public void parentTextUpdate() {
        if (!this.wasSetByAction) {
            this.wasSetByAction = true;
            this.updateText();
        }
    }

    public void updateText() {
        this.setText(this.textField.getText());
        this.setGraphic(null);
    }

    public void openLabelEditor() {
        this.wasSetByAction = false;
        this.oldText = this.getText();
        this.setText("");
        this.textField.setText(this.oldText);
        this.setGraphic(this.textField);
        this.textField.selectAll();
        this.textField.requestFocus();
    }

    private void setCssStyleClass(String className) {
        this.getStyleClass().clear();
        this.getStyleClass().add(className);
    }

    public void setDoubleClickEdit(Boolean bool) {
        this.doucleClickEnabled = bool;
        this.setCssStyleClass("double-click-disable-editable-label");
    }
}

