/*
 * Decompiled with CFR 0.152.
 */
package tarski.gui;

import com.jfoenix.controls.JFXButton;
import java.io.PrintStream;
import java.util.Arrays;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import tarski.core.controller.DataController;
import tarski.gui.common.AlertMaker;
import tarski.gui.common.ConsoleRedirect;
import tarski.gui.common.GlobalSettings;
import tarski.gui.common.ResizeHelper;
import tarski.gui.controller.TarskiMainController;

public class Tarski
extends Application {
    private static final double INITIAL_HEIGHT = 1000.0;
    private static final double INITIAL_WIDTH = 1400.0;
    private static Scene scene;
    private static Stage stage;

    @Override
    public void start(Stage primaryStage) {
        try {
            stage = primaryStage;
            stage.setOnHidden(event -> Tarski.closeProgram(event));
            stage.setOnCloseRequest(event -> Tarski.closeProgram(event));
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("Tarski.fxml"));
            Parent root = (Parent)fxmlLoader.load();
            TarskiMainController tarskiUIController = (TarskiMainController)fxmlLoader.getController();
            DataController dataController = new DataController();
            scene = new Scene(root);
            tarskiUIController.setStage(stage);
            tarskiUIController.setupCodeDrivenUi(dataController);
            scene.getStylesheets().add(this.getClass().getResource("word-highlight.css").toExternalForm());
            stage.setTitle("Tarski UdeS");
            stage.setScene(scene);
            if (ResizeHelper.isWindows()) {
                stage.initStyle(StageStyle.TRANSPARENT);
            } else {
                tarskiUIController.hideWindowsMenuBar();
            }
            Rectangle2D screenBounds = Screen.getPrimary().getBounds();
            if (screenBounds.getHeight() < 1000.0 || screenBounds.getWidth() < 1400.0) {
                stage.setHeight(screenBounds.getHeight() - 50.0);
                stage.setWidth(screenBounds.getWidth() - 50.0);
            } else {
                stage.setHeight(900.0);
                stage.setWidth(1300.0);
            }
            stage.setMinHeight(700.0);
            stage.setMinWidth(800.0);
            stage.show();
            tarskiUIController.setSplitPaneDividerRatios();
            if (ResizeHelper.isWindows()) {
                ResizeHelper.addResizeListener(stage);
            }
            System.out.println("Tarski UdeS started.");
            System.out.println("Any unexpected errors will appear here. Please report them to the authors.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeProgram(WindowEvent event) {
        Stage closedStage = (Stage)event.getSource();
        if (closedStage == stage) {
            event.consume();
            Tarski.closeProgram();
        } else {
            stage.close();
        }
    }

    public static void closeProgram() {
        if (GlobalSettings.wasChangeSinceLastSave()) {
            JFXButton quit = new JFXButton("Quit");
            JFXButton cancel = new JFXButton("Cancel");
            quit.setOnAction(replaceEvent -> {
                Platform.exit();
                System.exit(0);
                System.out.println("Tarski UdeS exited.");
            });
            AlertMaker.showMaterialDialog(Arrays.asList(quit, cancel), "Unsaved progress", "You are about to exit without exporting your last changes. Are you sure?");
        } else {
            Platform.exit();
            System.exit(0);
            System.out.println("Tarski UdeS exited.");
        }
    }

    public static Scene getScene() {
        return scene;
    }

    public void redirectConsoleOutputToApplication() {
        PrintStream ps = new PrintStream(new ConsoleRedirect());
        System.setOut(ps);
        System.setErr(ps);
    }

    public static void main(String[] args) {
        Tarski.launch(args);
    }
}

