/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import tarski.core.block.Block;
import tarski.core.formula.BinaryPredicate;
import tarski.core.formula.TernaryPredicate;
import tarski.core.formula.UnaryPredicate;

public class PredicateCreator {
    public static UnaryPredicate triangle() {
        return new UnaryPredicate("Triangle"){
            private static final long serialVersionUID = -4352353716398052577L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isTriangle();
            }
        };
    }

    public static UnaryPredicate square() {
        return new UnaryPredicate("Square"){
            private static final long serialVersionUID = -5162357336441516527L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isSquare();
            }
        };
    }

    public static UnaryPredicate pentagon() {
        return new UnaryPredicate("Pentagon"){
            private static final long serialVersionUID = -5162357336441516527L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isPentagon();
            }
        };
    }

    public static UnaryPredicate small() {
        return new UnaryPredicate("Small"){
            private static final long serialVersionUID = -4397083225228992175L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isSmall();
            }
        };
    }

    public static UnaryPredicate medium() {
        return new UnaryPredicate("Medium"){
            private static final long serialVersionUID = 8768247719513452630L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isMedium();
            }
        };
    }

    public static UnaryPredicate large() {
        return new UnaryPredicate("Large"){
            private static final long serialVersionUID = 6718723776744868678L;

            @Override
            public boolean evalPredicate(Block b) {
                return b.isLarge();
            }
        };
    }

    public static BinaryPredicate smaller() {
        return new BinaryPredicate("Smaller", false){
            private static final long serialVersionUID = 482428974065208241L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1.smaller(b2);
            }
        };
    }

    public static BinaryPredicate sameSize() {
        return new BinaryPredicate("SameSize", false){
            private static final long serialVersionUID = 8903275391088983434L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1.sameSize(b2);
            }
        };
    }

    public static BinaryPredicate sameCol() {
        return new BinaryPredicate("SameCol", false){
            private static final long serialVersionUID = -2614687814343809545L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1.sameCol(b2);
            }
        };
    }

    public static BinaryPredicate sameRow() {
        return new BinaryPredicate("SameRow", false){
            private static final long serialVersionUID = -8686421162402495994L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1.sameRow(b2);
            }
        };
    }

    public static BinaryPredicate leftOf() {
        return new BinaryPredicate("LeftOf", false){
            private static final long serialVersionUID = -5439310353116110951L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1.leftOf(b2);
            }
        };
    }

    public static BinaryPredicate equiv() {
        return new BinaryPredicate("=", true){
            private static final long serialVersionUID = -9002983710926329618L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1 == b2;
            }
        };
    }

    public static BinaryPredicate notEquiv() {
        return new BinaryPredicate("/=", true){
            private static final long serialVersionUID = -1390364915875921409L;

            @Override
            public boolean evalPredicate(Block b1, Block b2) {
                return b1 != b2;
            }
        };
    }

    public static TernaryPredicate between() {
        return new TernaryPredicate("Between"){
            private static final long serialVersionUID = 7863973551973138496L;

            @Override
            public boolean evalPredicate(Block b1, Block b2, Block b3) {
                return b1.between(b2, b3);
            }
        };
    }
}

