/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import generated.tarski_BaseVisitor;
import generated.tarski_Parser;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import tarski.core.formula.BinaryAtom;
import tarski.core.formula.BinaryPredicate;
import tarski.core.formula.Conjunction;
import tarski.core.formula.Disjunction;
import tarski.core.formula.Equivalence;
import tarski.core.formula.Exists;
import tarski.core.formula.Forall;
import tarski.core.formula.Formula;
import tarski.core.formula.Implication;
import tarski.core.formula.Negation;
import tarski.core.formula.TernaryAtom;
import tarski.core.formula.TernaryPredicate;
import tarski.core.formula.UnaryAtom;
import tarski.core.formula.UnaryPredicate;
import tarski.core.parser.ErrorArray;
import tarski.core.parser.ErrorType;
import tarski.core.parser.HighlightArray;
import tarski.core.parser.ParseError;
import tarski.core.parser.PredicateCreator;
import tarski.core.parser.TokenHighlight;
import tarski.core.parser.TokenType;

public class FormulaVisitor
extends tarski_BaseVisitor<Formula> {
    private ErrorArray errorArray;
    private HighlightArray highlightArray;
    private int parenthLevel = 0;

    public FormulaVisitor(ErrorArray errorArray, HighlightArray highlightArray) {
        this.errorArray = errorArray;
        this.highlightArray = highlightArray;
    }

    private int toCharInt(String var) {
        return var.charAt(0) - 97;
    }

    @Override
    public Formula visitFormula(tarski_Parser.FormulaContext ctx) {
        Formula formula;
        try {
            formula = (Formula)this.visit(ctx.expression_5());
        }
        catch (NullPointerException e) {
            this.errorArray.clear();
            formula = null;
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStartIndex();
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Unexpected error in parse tree."));
        }
        return formula;
    }

    @Override
    public Formula visitExpression_5(tarski_Parser.Expression_5Context ctx) {
        Formula formula;
        if (ctx.Equiv() != null && ctx.expression_4() != null) {
            boolean isInParentheses = this.isInParentheses();
            Formula left = (Formula)this.visit(ctx.expression_4(0));
            Formula right = (Formula)this.visit(ctx.expression_4(1));
            formula = new Equivalence(left, right, isInParentheses);
        } else if (ctx.expression_4() != null) {
            formula = (Formula)this.visit(ctx.expression_4(0));
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        return formula;
    }

    @Override
    public Formula visitExpression_4(tarski_Parser.Expression_4Context ctx) {
        Formula formula;
        if (ctx.Imply() != null) {
            boolean isInParentheses = this.isInParentheses();
            Formula left = (Formula)this.visit(ctx.expression_3());
            Formula right = (Formula)this.visit(ctx.expression_4());
            formula = new Implication(left, right, isInParentheses);
        } else if (ctx.expression_3() != null) {
            formula = (Formula)this.visit(ctx.expression_3());
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        return formula;
    }

    @Override
    public Formula visitExpression_3(tarski_Parser.Expression_3Context ctx) {
        Formula formula;
        if (ctx.expression_2() != null) {
            if (ctx.expression_2().size() > 1) {
                Formula[] formulas = new Formula[ctx.expression_2().size()];
                boolean isInParentheses = this.isInParentheses();
                for (int i = 0; i < ctx.expression_2().size(); ++i) {
                    formulas[i] = (Formula)this.visit(ctx.expression_2(i));
                }
                formula = new Disjunction(formulas, isInParentheses);
            } else {
                formula = (Formula)this.visit(ctx.expression_2(0));
            }
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        return formula;
    }

    @Override
    public Formula visitExpression_2(tarski_Parser.Expression_2Context ctx) {
        Formula formula;
        if (ctx.expression_1() != null) {
            if (ctx.expression_1().size() > 1) {
                Formula[] formulas = new Formula[ctx.expression_1().size()];
                boolean isInParentheses = this.isInParentheses();
                for (int i = 0; i < ctx.expression_1().size(); ++i) {
                    formulas[i] = (Formula)this.visit(ctx.expression_1(i));
                }
                formula = new Conjunction(formulas, isInParentheses);
            } else {
                formula = (Formula)this.visit(ctx.expression_1(0));
            }
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        return formula;
    }

    @Override
    public Formula visitExpression_1(tarski_Parser.Expression_1Context ctx) {
        Formula formula;
        boolean isInParentheses = false;
        if (ctx.Not() != null) {
            isInParentheses = this.isInParentheses();
        }
        if (ctx.LEFTPAR() != null) {
            ++this.parenthLevel;
        }
        if (ctx.atom() != null) {
            formula = (Formula)this.visit(ctx.atom());
        } else if (ctx.expression_5() != null) {
            formula = (Formula)this.visit(ctx.expression_5());
        } else if (ctx.quantifier() != null) {
            formula = (Formula)this.visit(ctx.quantifier());
        } else if (ctx.unknown_quantifier() != null) {
            formula = (Formula)this.visit(ctx.unknown_quantifier());
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        if (ctx.Not() != null) {
            for (TerminalNode not : ctx.Not()) {
                Formula contained = formula;
                formula = new Negation(contained, isInParentheses);
            }
        }
        return formula;
    }

    @Override
    public Formula visitQuantifier(tarski_Parser.QuantifierContext ctx) {
        Formula formula;
        int var = this.toCharInt(ctx.ID().getText());
        if (ctx.Exist() != null) {
            Formula content = (Formula)this.visit(ctx.expression_5());
            formula = new Exists(var, content, this.isInParentheses());
            int start = ctx.start.getStartIndex();
            int stop = ctx.start.getStartIndex();
            this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.QUANTIFIER, start, stop));
            this.highlightQuantifier(ctx);
        } else if (ctx.ForAll() != null) {
            Formula content = (Formula)this.visit(ctx.expression_5());
            formula = new Forall(var, content, this.isInParentheses());
            int start = ctx.start.getStartIndex();
            int stop = ctx.start.getStartIndex();
            this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.QUANTIFIER, start, stop));
            this.highlightQuantifier(ctx);
        } else {
            return (Formula)this.visitChildren(ctx);
        }
        return formula;
    }

    private void highlightQuantifier(tarski_Parser.QuantifierContext ctx) {
        String quantifierVar = ctx.ID().getText();
        List<TerminalNode> subIdList = this.getSubNodes(ctx);
        Boolean foundVar = false;
        for (TerminalNode node : subIdList) {
            if (!node.getText().equals(quantifierVar)) continue;
            if (node.getSymbol().getStartIndex() != ctx.ID().getSymbol().getStartIndex()) {
                foundVar = true;
            }
            int start = node.getSymbol().getStartIndex();
            int stop = node.getSymbol().getStartIndex();
            this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.QUANTIFIER_VARIABLE, start, stop));
        }
        if (!foundVar.booleanValue()) {
            this.errorArray.addParseError(new ParseError(ErrorType.SEMANTIC, ctx.ID().getSymbol().getLine(), ctx.ID().getSymbol().getStartIndex(), ctx.ID().getSymbol().getStopIndex(), "Unused variable"));
        }
    }

    private List<TerminalNode> getSubNodes(ParserRuleContext ctx) {
        ArrayList<TerminalNode> terminalNodes = new ArrayList<TerminalNode>();
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            if (ctx.getChild(i) instanceof TerminalNode) {
                terminalNodes.add((TerminalNode)ctx.getChild(i));
                continue;
            }
            if (!(ctx.getChild(i) instanceof ParserRuleContext)) continue;
            terminalNodes.addAll(this.getSubNodes((ParserRuleContext)ctx.getChild(i)));
        }
        return terminalNodes;
    }

    @Override
    public Formula visitUnknown_quantifier(tarski_Parser.Unknown_quantifierContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Unknown quantifier used."));
        }
        return null;
    }

    @Override
    public Formula visitUnknown_predicate(tarski_Parser.Unknown_predicateContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Unknown predicate used."));
        }
        return null;
    }

    @Override
    public Formula visitInvalid_params_unary_predicate(tarski_Parser.Invalid_params_unary_predicateContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.unary_predicate_name().stop.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Invalid number of parameters. Should be 1 for unary predicate of format [a-z]."));
        }
        return null;
    }

    @Override
    public Formula visitInvalid_params_binary_predicate(tarski_Parser.Invalid_params_binary_predicateContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.binary_predicate_name().stop.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Invalid number of parameters. Should be 2 for binary predicate of format [a-z]."));
        }
        return null;
    }

    @Override
    public Formula visitInvalid_params_ternary_predicate(tarski_Parser.Invalid_params_ternary_predicateContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.ternary_predicate_name().stop.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Invalid number of parameters. Should be 3 for ternary predicate of format [a-z]."));
        }
        return null;
    }

    @Override
    public Formula visitUnary_predicate(tarski_Parser.Unary_predicateContext ctx) {
        UnaryPredicate pred;
        String token = ctx.unary_predicate_name().getText();
        int var = this.toCharInt(ctx.ID().getText());
        int start = ctx.unary_predicate_name().start.getStartIndex();
        int stop = ctx.unary_predicate_name().stop.getStopIndex() + 1;
        this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.UNARY_PREDICATE, start, stop));
        switch (token) {
            case "Triangle": {
                pred = PredicateCreator.triangle();
                break;
            }
            case "Square": {
                pred = PredicateCreator.square();
                break;
            }
            case "Pentagon": {
                pred = PredicateCreator.pentagon();
                break;
            }
            case "Small": {
                pred = PredicateCreator.small();
                break;
            }
            case "Medium": {
                pred = PredicateCreator.medium();
                break;
            }
            case "Large": {
                pred = PredicateCreator.large();
                break;
            }
            default: {
                pred = PredicateCreator.triangle();
            }
        }
        UnaryAtom atom = new UnaryAtom(pred, var, this.isInParentheses());
        return atom;
    }

    @Override
    public Formula visitBinary_predicate(tarski_Parser.Binary_predicateContext ctx) {
        BinaryPredicate pred;
        String idLeft = ctx.ID(0).getText();
        String idRight = ctx.ID(1).getText();
        if (ctx.binary_predicate_name() != null) {
            int start = ctx.binary_predicate_name().start.getStartIndex();
            int stop = ctx.binary_predicate_name().stop.getStopIndex() + 1;
            this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.BINARY_PREDICATE, start, stop));
            pred = this.visitFunctionBinary_predicate(ctx);
        } else {
            pred = ctx.EQ() != null ? this.visitEquiv(ctx) : this.visitNotEquiv(ctx);
        }
        BinaryAtom atom = new BinaryAtom(pred, this.toCharInt(idLeft), this.toCharInt(idRight), this.isInParentheses());
        return atom;
    }

    private BinaryPredicate visitFunctionBinary_predicate(tarski_Parser.Binary_predicateContext ctx) {
        BinaryPredicate pred;
        String binaryPredicateName;
        switch (binaryPredicateName = ctx.binary_predicate_name().getText()) {
            case "Smaller": {
                pred = PredicateCreator.smaller();
                break;
            }
            case "SameSize": {
                pred = PredicateCreator.sameSize();
                break;
            }
            case "SameCol": {
                pred = PredicateCreator.sameCol();
                break;
            }
            case "SameRow": {
                pred = PredicateCreator.sameRow();
                break;
            }
            case "LeftOf": {
                pred = PredicateCreator.leftOf();
                break;
            }
            default: {
                pred = PredicateCreator.smaller();
            }
        }
        return pred;
    }

    @Override
    public Formula visitTernary_predicate(tarski_Parser.Ternary_predicateContext ctx) {
        TernaryPredicate pred;
        String ternaryPredicateName;
        String idLeft = ctx.ID(0).getText();
        String idCenter = ctx.ID(1).getText();
        String idRight = ctx.ID(2).getText();
        int start = ctx.ternary_predicate_name().start.getStartIndex();
        int stop = ctx.ternary_predicate_name().stop.getStopIndex() + 1;
        this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.TERNARY_PREDICATE, start, stop));
        switch (ternaryPredicateName = ctx.ternary_predicate_name().getText()) {
            case "Between": {
                pred = PredicateCreator.between();
                break;
            }
            default: {
                pred = PredicateCreator.between();
            }
        }
        return new TernaryAtom(pred, this.toCharInt(idLeft), this.toCharInt(idCenter), this.toCharInt(idRight), this.isInParentheses());
    }

    private BinaryPredicate visitEquiv(tarski_Parser.Binary_predicateContext ctx) {
        return PredicateCreator.equiv();
    }

    private BinaryPredicate visitNotEquiv(tarski_Parser.Binary_predicateContext ctx) {
        return PredicateCreator.notEquiv();
    }

    @Override
    public Formula visitUnknown_string(tarski_Parser.Unknown_stringContext ctx) {
        if (ctx.start != null && ctx.stop != null) {
            int start = ctx.start.getStartIndex();
            int stop = ctx.stop.getStartIndex() + 1;
            this.errorArray.addParseError(new ParseError(ErrorType.LEXICAL, ctx.getStart().getLine(), start, stop, "Unknown string."));
        }
        return null;
    }

    private boolean isInParentheses() {
        if (this.parenthLevel > 0) {
            --this.parenthLevel;
            return true;
        }
        return false;
    }
}

