/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import java.util.ArrayList;

public class Formatter {
    private String text = "";
    private ArrayList<Integer> indents = new ArrayList();
    public static final int regularIndent = 2;
    public static final int threeSpaceIndent = 3;
    public static final int fourSpaceIndent = 4;
    private static final String standardSpace = " ";
    public boolean newLine = true;

    public void openParentheses() {
        this.nextLine();
        this.addText("(");
        this.nextLine();
        this.indents.add(2);
        this.newLine = true;
    }

    public void closeParentheses() {
        this.nextLine();
        this.indents.remove(this.indents.size() - 1);
        this.addText(")");
        this.nextLine();
        this.newLine = true;
    }

    private void addText(String text, boolean isOperator) {
        for (Integer each : this.indents) {
            for (int i = 0; i < each; ++i) {
                this.text = this.text + standardSpace;
            }
        }
        this.newLine = false;
        this.text = this.text + text;
    }

    public void addText(String text) {
        this.addText(text, false);
    }

    public void addOperator(String operator) {
        this.nextLine();
        this.addText(operator, true);
    }

    public void addOperator(String operator, int indentLevel) {
        this.nextLine();
        this.addText(operator, true);
        this.indents.add(indentLevel);
    }

    public void addBinaryOperator(String operator) {
        this.nextLine();
        this.addText(operator, true);
        this.nextLine();
    }

    public void openOperator(int indentLevel) {
        this.nextLine();
        this.indents.add(indentLevel);
    }

    public void insertOperator(String operator) {
        this.nextLine();
        Integer last = this.indents.get(this.indents.size() - 1);
        this.indents.remove(this.indents.size() - 1);
        this.addText(operator, true);
        this.indents.add(last);
        this.nextLine();
    }

    public void closeOperator() {
        this.nextLine();
        this.indents.remove(this.indents.size() - 1);
    }

    public String getFormattedText() {
        return this.text;
    }

    private void nextLine() {
        if (!this.newLine) {
            this.text = this.text + "\n";
            this.newLine = true;
        }
    }
}

