/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import tarski.core.parser.ErrorArray;
import tarski.core.parser.ErrorType;
import tarski.core.parser.ParseError;

public class ErrorListener
extends BaseErrorListener {
    private ErrorArray errorArray;
    private CommonTokenStream tokens;

    public ErrorListener(ErrorArray errorArray, CommonTokenStream tokens) {
        this.errorArray = errorArray;
        this.tokens = tokens;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (offendingSymbol instanceof CommonToken) {
            CommonToken symbol = (CommonToken)offendingSymbol;
            if (msg.contains("mismatched") || msg.contains("extraneous")) {
                int start = symbol.getStartIndex();
                int stop = symbol.getStopIndex();
                this.errorArray.addParseError(new ParseError(ErrorType.SYNTAXE, line, start, stop, msg));
            } else {
                int tokenIndex = symbol.getTokenIndex();
                Token previous = tokenIndex > 0 ? this.tokens.get(tokenIndex - 1) : symbol;
                int start = previous.getStartIndex();
                int stop = previous.getStopIndex() + 1;
                int newLine = previous.getLine();
                this.errorArray.addParseError(new ParseError(ErrorType.SYNTAXE, newLine, start, stop, msg));
            }
        } else {
            this.errorArray.addParseError(new ParseError(ErrorType.SYNTAXE, line, charPositionInLine, Integer.MAX_VALUE, msg));
        }
    }
}

