/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import java.util.ArrayList;
import java.util.List;
import tarski.core.parser.ErrorType;
import tarski.core.parser.ParseError;
import tarski.gui.common.Logger;

public class ErrorArray {
    private List<ParseError> parseErrors = new ArrayList<ParseError>();
    private String text;
    private int lengthOfSanitizedErrors = 0;

    public ErrorArray(String text) {
        this.text = text;
    }

    public Boolean hasFailingErrors() {
        for (ParseError error : this.parseErrors) {
            if (!error.getErrorType().equals((Object)ErrorType.LEXICAL) && !error.getErrorType().equals((Object)ErrorType.SYNTAXE)) continue;
            return true;
        }
        return false;
    }

    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    public void addParseError(ParseError parseError) {
        this.parseErrors.add(parseError);
    }

    public void addByFind(ParseError parseError, String toFind) {
        int start = this.text.indexOf(toFind);
        int stop = start + toFind.length();
        parseError.setStart(start);
        parseError.setStop(stop);
        this.parseErrors.add(parseError);
    }

    public void clear() {
        this.parseErrors.clear();
    }

    public void printErrorsToLog() {
        for (ParseError error : this.parseErrors) {
            Logger.getLogger().parserLog(error.toString());
        }
    }

    public void sanitizeErrors() {
        ArrayList<ParseError> sanitizedErrors = new ArrayList<ParseError>();
        for (ParseError parseError : this.parseErrors) {
            ParseError collided;
            if (parseError.getStart() > parseError.getStop()) {
                parseError.setStop(parseError.getStart());
            }
            if (parseError.getStart() > this.text.length()) {
                parseError.setStart(this.text.length());
            }
            if (parseError.getStop() > this.text.length()) {
                parseError.setStop(this.text.length());
            }
            if ((collided = this.getCollision(sanitizedErrors, parseError)) != null) {
                if (collided.getSize() >= parseError.getSize()) continue;
                sanitizedErrors.remove(collided);
                this.addParseErrorToList(sanitizedErrors, parseError);
                continue;
            }
            this.addParseErrorToList(sanitizedErrors, parseError);
        }
        this.parseErrors = sanitizedErrors;
    }

    private ParseError getCollision(List<ParseError> list, ParseError parseError) {
        ParseError collided = null;
        for (ParseError curr : list) {
            if (parseError.getLine() != curr.getLine()) continue;
            if (parseError.getStop() >= curr.getStart() && parseError.getStop() <= curr.getStop()) {
                collided = curr;
            }
            if (parseError.getStart() < curr.getStart() || parseError.getStart() > curr.getStop()) continue;
            collided = curr;
        }
        return collided;
    }

    private void addParseErrorToList(List<ParseError> list, ParseError parseError) {
        if (list.isEmpty()) {
            list.add(parseError);
        } else if (parseError.getSize() + this.lengthOfSanitizedErrors <= this.text.length()) {
            Boolean added = false;
            for (int i = 0; i < list.size(); ++i) {
                if (parseError.getStart() >= list.get(i).getStop()) continue;
                list.add(i, parseError);
                this.lengthOfSanitizedErrors += this.text.length();
                added = true;
                break;
            }
            if (!added.booleanValue()) {
                list.add(parseError);
            }
        }
    }
}

