/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.parser;

import generated.tarski_Lexer;
import generated.tarski_Parser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Token;
import tarski.core.formula.Formula;
import tarski.core.parser.ErrorArray;
import tarski.core.parser.ErrorListener;
import tarski.core.parser.Formatter;
import tarski.core.parser.FormulaParser;
import tarski.core.parser.FormulaVisitor;
import tarski.core.parser.HighlightArray;
import tarski.core.parser.ParseError;
import tarski.core.parser.TokenHighlight;
import tarski.core.parser.TokenType;
import tarski.gui.common.Logger;

public class AntlrParser
implements FormulaParser,
Serializable {
    private static final long serialVersionUID = -1593692412074450305L;
    private transient ErrorArray errorArray = new ErrorArray("");
    private transient HighlightArray highlightArray = new HighlightArray();
    private ArrayList<String> comments = new ArrayList();
    private String formattedText = "";

    @Override
    public Formula parseFormula(String text) {
        Logger.getLogger().parserLog("Parsing...");
        Formula formula = null;
        if (text != null) {
            if (!text.equals("")) {
                tarski_Lexer tarskiLexer = new tarski_Lexer(CharStreams.fromString(text));
                CommonTokenStream tokens = new CommonTokenStream(tarskiLexer);
                tarski_Parser parser = new tarski_Parser(tokens);
                this.errorArray = new ErrorArray(text);
                this.highlightArray = new HighlightArray();
                parser.addErrorListener(new ErrorListener(this.errorArray, tokens));
                parser.removeErrorListener(ConsoleErrorListener.INSTANCE);
                tarski_Parser.FormulaContext tree = parser.formula();
                FormulaVisitor formulaVisitor = new FormulaVisitor(this.errorArray, this.highlightArray);
                formula = (Formula)formulaVisitor.visit(tree);
                this.errorArray.printErrorsToLog();
                this.errorArray.sanitizeErrors();
                this.errorArray.getParseErrors();
                this.addCommentHighlights(tokens);
                if (this.errorArray.hasFailingErrors().booleanValue()) {
                    formula = null;
                    this.formattedText = "";
                } else {
                    this.formattedText = formula.generateFormattedText(new Formatter()).getFormattedText();
                    for (String each : this.comments) {
                        this.formattedText = this.formattedText + each + "\n";
                    }
                }
                Logger.getLogger().parserLog("Done parsing\n");
            } else {
                this.errorArray.clear();
            }
        }
        return formula;
    }

    @Override
    public String getFormattedText() {
        return this.formattedText;
    }

    @Override
    public List<ParseError> getParseErrors() {
        return this.errorArray.getParseErrors();
    }

    @Override
    public List<TokenHighlight> getTokenHighlights() {
        return this.highlightArray.getTokenHighlights();
    }

    private void addCommentHighlights(CommonTokenStream tokens) {
        this.comments.clear();
        for (int index = 0; index < tokens.size(); ++index) {
            Token token = tokens.get(index);
            if (token.getType() == 1) continue;
            List<Token> hiddenTokensToLeft = tokens.getHiddenTokensToLeft(index);
            for (int i = 0; hiddenTokensToLeft != null && i < hiddenTokensToLeft.size(); ++i) {
                if (hiddenTokensToLeft.get(i).getType() == 1 || hiddenTokensToLeft.get(i).getChannel() != 2) continue;
                int start = hiddenTokensToLeft.get(i).getStartIndex();
                int stop = hiddenTokensToLeft.get(i).getStopIndex() + 1;
                if (this.comments.contains(hiddenTokensToLeft.get(i).getText())) continue;
                this.highlightArray.addTokenHighlightToList(new TokenHighlight(TokenType.COMMENT, start, stop));
                this.comments.add(hiddenTokensToLeft.get(i).getText());
            }
        }
    }
}

