/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.block.Block;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.formula.UnaryPredicate;
import tarski.core.parser.Formatter;

public class UnaryAtom
extends Formula {
    private UnaryPredicate pred;
    private int var;

    public UnaryAtom(UnaryPredicate pred, int var, boolean isInParentheses) {
        super(isInParentheses);
        this.pred = pred;
        this.var = var;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block b = alpha.eval(this.var);
        Boolean ret = this.pred.eval(b);
        blocks.add(b);
        StringBuffer sBuf = new StringBuffer();
        this.append(sBuf, -1, alpha);
        this.result = new FormulaEvalResult(sBuf.toString(), blocks, ret);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        String blockName1 = this.getBlockName(alpha, this.var);
        b.append(this.pred.getName());
        b.append('(');
        b.append(blockName1);
        b.append(')');
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        this.append(b, 0, alpha);
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.addText(this.pred.getName() + "(" + this.intToChar(this.var) + ")");
        return formatter;
    }
}

