/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.block.Block;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.formula.TernaryPredicate;
import tarski.core.parser.Formatter;

public class TernaryAtom
extends Formula {
    private TernaryPredicate pred;
    private int var1;
    private int var2;
    private int var3;

    public TernaryAtom(TernaryPredicate pred, int var1, int var2, int var3, boolean isInParentheses) {
        super(isInParentheses);
        this.pred = pred;
        this.var1 = var1;
        this.var2 = var2;
        this.var3 = var3;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block b1 = alpha.eval(this.var1);
        Block b2 = alpha.eval(this.var2);
        Block b3 = alpha.eval(this.var3);
        Boolean ret = this.pred.eval(b1, b2, b3);
        blocks.add(b1);
        blocks.add(b2);
        blocks.add(b3);
        StringBuffer sBuf = new StringBuffer();
        this.append(sBuf, -1, alpha);
        this.result = new FormulaEvalResult(sBuf.toString(), blocks, ret);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        String blockName1 = this.getBlockName(alpha, this.var1);
        String blockName2 = this.getBlockName(alpha, this.var2);
        String blockName3 = this.getBlockName(alpha, this.var3);
        b.append(this.pred.getName());
        b.append('(');
        b.append(blockName1);
        b.append(',');
        b.append(blockName2);
        b.append(',');
        b.append(blockName3);
        b.append(')');
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        this.append(b, 0, alpha);
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.addText(this.pred.getName() + "(" + this.intToChar(this.var1) + "," + this.intToChar(this.var2) + "," + this.intToChar(this.var3) + ")");
        return formatter;
    }
}

