/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public class Negation
extends Formula {
    public static final int PRECEDENCE = 1;
    private Formula arg;

    public Negation(Formula arg, boolean isInParentheses) {
        super(isInParentheses);
        this.arg = arg;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<FormulaEvalResult> collectedResults = new ArrayList<FormulaEvalResult>();
        FormulaEvalResult evalResult = this.arg.eval(world, alpha);
        Boolean ret = evalResult.getResult() == false;
        collectedResults.add(evalResult);
        this.result = new FormulaEvalResult(this.toOperatorString(alpha), null, ret);
        this.result.setResults(collectedResults);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        if (prec < 1) {
            b.append('(');
        }
        b.append("Not ");
        this.arg.append(b, 1, alpha);
        if (prec < 1) {
            b.append(')');
        }
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        b.append("Not ");
        b.append(alpha.substitutionsToString());
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.addOperator("not");
        formatter.openOperator(4);
        if (this.arg.isInParentheses()) {
            formatter.openParentheses();
        }
        this.arg.generateFormattedText(formatter);
        if (this.arg.isInParentheses()) {
            formatter.closeParentheses();
        }
        formatter.closeOperator();
        return formatter;
    }
}

