/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import tarski.core.block.Block;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public abstract class Formula {
    public static final int PRECEDENCE = 6;
    protected FormulaEvalResult result;
    private boolean isInParentheses = false;

    public Formula(boolean isInParentheses) {
        this.isInParentheses = isInParentheses;
    }

    public abstract FormulaEvalResult eval(WorldController var1, Assignment var2) throws EvalException;

    public boolean eval(WorldController world) throws EvalException {
        if (world.isEmpty()) {
            throw new EvalException("world is empty");
        }
        Assignment alpha = new Assignment();
        for (Block currentBlock : world.getBlocks()) {
            Block nextBlock = currentBlock;
            if (!nextBlock.hasName()) continue;
            alpha.set(nextBlock.getNameIndex(), nextBlock);
        }
        Boolean result = this.eval(world, alpha).getResult();
        return result;
    }

    public abstract void append(StringBuffer var1, int var2, Assignment var3);

    public abstract void appendOperator(StringBuffer var1, Assignment var2);

    public abstract Formatter generateFormattedText(Formatter var1);

    public String toString(Assignment alpha) {
        StringBuffer b = new StringBuffer();
        this.append(b, 6, alpha);
        return b.toString();
    }

    public String toOperatorString(Assignment alpha) {
        StringBuffer b = new StringBuffer();
        this.appendOperator(b, alpha);
        return b.toString();
    }

    public FormulaEvalResult getFormulaEvalResult() {
        return this.result;
    }

    public String getBlockName(Assignment alpha, int var) {
        Object blockName = "empty";
        Block b1 = alpha.get(var);
        blockName = b1 != null ? (!b1.getName().equals("") ? b1.getName() : "'" + b1.getBlockSize().name() + " " + b1.getBlockType().name() + "'") : String.valueOf((char)(97 + var));
        return blockName;
    }

    protected char intToChar(int var) {
        return (char)(97 + var);
    }

    public boolean isInParentheses() {
        return this.isInParentheses;
    }
}

