/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.block.Block;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public class Forall
extends Formula {
    public static final int PRECEDENCE = 1;
    private int var;
    private Formula arg;

    public Forall(int var, Formula arg, boolean isInParentheses) {
        super(isInParentheses);
        this.var = var;
        this.arg = arg;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<FormulaEvalResult> collectedResults = new ArrayList<FormulaEvalResult>();
        Block old = alpha.get(this.var);
        Boolean ret = true;
        for (Block b : world.getBlocks()) {
            alpha.setFromQuantifier(this.var, b);
            FormulaEvalResult currentResult = this.arg.eval(world, alpha);
            if (!currentResult.getResult().booleanValue()) {
                alpha.set(this.var, old);
                ret = false;
            }
            collectedResults.add(currentResult);
        }
        alpha.setFromQuantifier(this.var, old);
        this.result = new FormulaEvalResult(this.toOperatorString(alpha), null, ret);
        this.result.setResults(collectedResults);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        if (prec < 1) {
            b.append('(');
        }
        b.append("! ");
        b.append((char)(97 + this.var));
        b.append(" ");
        this.arg.append(b, 1, alpha);
        if (prec < 1) {
            b.append(')');
        }
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        b.append("! ");
        b.append((char)(97 + this.var));
        b.append(" ");
        b.append(alpha.substitutionsToString());
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.addOperator("!" + this.intToChar(this.var) + ".");
        formatter.openParentheses();
        this.arg.generateFormattedText(formatter);
        formatter.closeParentheses();
        return formatter;
    }
}

