/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public class Equivalence
extends Formula {
    public static final int PRECEDENCE = 5;
    private Formula arg1;
    private Formula arg2;

    public Equivalence(Formula arg1, Formula arg2, boolean isInParentheses) {
        super(isInParentheses);
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        FormulaEvalResult arg1EvalResult = this.arg1.eval(world, alpha);
        FormulaEvalResult arg2EvalResult = this.arg2.eval(world, alpha);
        Boolean evalResult = arg1EvalResult.getResult() == arg2EvalResult.getResult();
        ArrayList<FormulaEvalResult> collectedResults = new ArrayList<FormulaEvalResult>();
        collectedResults.add(arg1EvalResult);
        collectedResults.add(arg2EvalResult);
        this.result = new FormulaEvalResult(this.toOperatorString(alpha), null, evalResult);
        this.result.setResults(collectedResults);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        if (prec < 5) {
            b.append('(');
        }
        this.arg1.append(b, 4, alpha);
        b.append(" <=> ");
        this.arg2.append(b, 4, alpha);
        if (prec < 5) {
            b.append(')');
        }
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        b.append("<=> ");
        b.append(alpha.substitutionsToString());
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.openOperator(4);
        if (this.arg1.isInParentheses()) {
            formatter.openParentheses();
        }
        this.arg1.generateFormattedText(formatter);
        if (this.arg1.isInParentheses()) {
            formatter.closeParentheses();
        }
        formatter.insertOperator("<=>");
        if (this.arg2.isInParentheses()) {
            formatter.openParentheses();
        }
        this.arg2.generateFormattedText(formatter);
        if (this.arg2.isInParentheses()) {
            formatter.closeParentheses();
        }
        formatter.closeOperator();
        return formatter;
    }
}

