/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public class Disjunction
extends Formula {
    public static final int PRECEDENCE = 3;
    private Formula[] args;

    public Disjunction(Formula[] args, boolean isInParentheses) {
        super(isInParentheses);
        this.args = args;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<FormulaEvalResult> collectedResults = new ArrayList<FormulaEvalResult>();
        Boolean ret = false;
        for (int i = 0; i < this.args.length; ++i) {
            FormulaEvalResult currEvalResult = this.args[i].eval(world, alpha);
            if (currEvalResult.getResult().booleanValue()) {
                ret = true;
            }
            collectedResults.add(currEvalResult);
        }
        this.result = new FormulaEvalResult(this.toOperatorString(alpha), null, ret);
        this.result.setResults(collectedResults);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        if (this.args.length == 0) {
            b.append("ff");
            return;
        }
        if (this.args.length == 1) {
            this.args[0].append(b, prec, alpha);
            return;
        }
        if (prec < 3) {
            b.append('(');
        }
        this.args[0].append(b, 3, alpha);
        for (int i = 1; i < this.args.length; ++i) {
            b.append(" Or ");
            this.args[i].append(b, 3, alpha);
        }
        if (prec < 3) {
            b.append(')');
        }
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        b.append("Or ");
        b.append(alpha.substitutionsToString());
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        formatter.openOperator(3);
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].isInParentheses()) {
                formatter.openParentheses();
            }
            this.args[i].generateFormattedText(formatter);
            if (this.args[i].isInParentheses()) {
                formatter.closeParentheses();
            }
            if (i + 1 == this.args.length) continue;
            formatter.insertOperator("or");
        }
        formatter.closeOperator();
        return formatter;
    }
}

