/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import java.util.ArrayList;
import tarski.core.block.Block;
import tarski.core.controller.WorldController;
import tarski.core.formula.Assignment;
import tarski.core.formula.BinaryPredicate;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.formula.FormulaEvalResult;
import tarski.core.parser.Formatter;

public class BinaryAtom
extends Formula {
    private BinaryPredicate pred;
    private int var1;
    private int var2;

    public BinaryAtom(BinaryPredicate pred, int var1, int var2, boolean isInParentheses) {
        super(isInParentheses);
        this.pred = pred;
        this.var1 = var1;
        this.var2 = var2;
    }

    @Override
    public FormulaEvalResult eval(WorldController world, Assignment alpha) throws EvalException {
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block b1 = alpha.eval(this.var1);
        Block b2 = alpha.eval(this.var2);
        Boolean ret = this.pred.eval(b1, b2);
        blocks.add(b1);
        blocks.add(b2);
        StringBuffer sBuf = new StringBuffer();
        this.append(sBuf, -1, alpha);
        this.result = new FormulaEvalResult(sBuf.toString(), blocks, ret);
        return this.result;
    }

    @Override
    public void append(StringBuffer b, int prec, Assignment alpha) {
        String blockName1 = this.getBlockName(alpha, this.var1);
        String blockName2 = this.getBlockName(alpha, this.var2);
        if (this.pred.isInfix()) {
            b.append(blockName1);
            b.append(" ");
            b.append(this.pred.getName());
            b.append(" ");
            b.append(blockName2);
        } else {
            b.append(this.pred.getName());
            b.append('(');
            b.append(blockName1);
            b.append(',');
            b.append(blockName2);
            b.append(')');
        }
    }

    public String toStringBlock(Block b1, Block b2) {
        String blockName1 = "empty";
        String blockName2 = "empty";
        if (!b1.getName().equals("")) {
            blockName1 = b1.getName();
        }
        if (!b2.getName().equals("")) {
            blockName2 = b2.getName();
        }
        return this.pred.getName() + "(" + blockName1 + "," + blockName2 + ")";
    }

    @Override
    public void appendOperator(StringBuffer b, Assignment alpha) {
        this.append(b, 0, alpha);
    }

    @Override
    public Formatter generateFormattedText(Formatter formatter) {
        if (this.pred.isInfix()) {
            formatter.addText(this.intToChar(this.var1) + " " + this.pred.getName() + " " + this.intToChar(this.var2));
        } else {
            formatter.addText(this.pred.getName() + "(" + this.intToChar(this.var1) + "," + this.intToChar(this.var2) + ")");
        }
        return formatter;
    }
}

