/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.formula;

import tarski.core.block.Block;
import tarski.core.formula.EvalException;
import tarski.core.formula.Substitution;

public class Assignment {
    private Block[] alpha = new Block[26];
    private Substitution[] substitutions = new Substitution[26];

    Assignment() {
    }

    public void set(int i, Block b) {
        this.alpha[i] = b;
    }

    public void setFromQuantifier(int i, Block b) {
        this.substitutions[i] = new Substitution((char)(97 + i), b);
        this.alpha[i] = b;
    }

    public Block get(int i) {
        return this.alpha[i];
    }

    public Block eval(int i) throws EvalException {
        Block b = this.alpha[i];
        if (b == null) {
            throw new EvalException((char)(97 + i) + " is not defined");
        }
        return b;
    }

    public String substitutionsToString() {
        Object ret = "(";
        boolean isFirst = true;
        for (int i = 0; i < this.substitutions.length; ++i) {
            if (this.substitutions[i] == null) continue;
            if (!isFirst) {
                ret = (String)ret + ", ";
            } else {
                isFirst = false;
            }
            ret = (String)ret + this.substitutions[i].getSubstitutedVar();
            if (this.substitutions[i].getCurrentBlock() == null) continue;
            ret = !this.substitutions[i].getCurrentBlock().getName().equals("") ? (String)ret + "=" + this.substitutions[i].getCurrentBlock().getName() : (String)ret + "=" + this.substitutions[i].getCurrentBlock().getBlockSize().toString() + "_" + this.substitutions[i].getCurrentBlock().getBlockType().toString();
        }
        ret = (String)ret + ")";
        return ret;
    }
}

