/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.controller;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import tarski.core.block.Block;
import tarski.core.block.BlockSize;
import tarski.core.block.BlockType;
import tarski.core.controller.BlockPos;
import tarski.core.controller.Controller;
import tarski.core.controller.Tile;
import tarski.core.controller.factory.WorldControllerFactory;
import tarski.gui.common.GlobalSettings;

public final class WorldController
extends Controller<WorldController> {
    private static final long serialVersionUID = 3944524081781207522L;
    public static final int TILE_NUMBER_PER_LINE = 8;
    private Boolean worldShouldPass = true;
    private ArrayList<ArrayList<Tile>> tiles = new ArrayList();
    private String validBlockNameRegex = "[a-z]";

    public WorldController(JsonNode jn, Controller<?> parent) {
        this(parent);
        this.setName(jn.get("worldName").asText());
        this.setParent(parent);
        this.worldShouldPass = jn.get("worldShouldPass").asBoolean(true);
        ArrayNode blocks = (ArrayNode)jn.get("blocks");
        ArrayList<Block> blocksToAdd = new ArrayList<Block>();
        for (JsonNode blockNode : blocks) {
            blocksToAdd.add(new Block(blockNode));
        }
        this.setBlocks(blocksToAdd);
    }

    @Override
    public ObjectNode toJson(ObjectMapper om, Controller<?> parent) {
        ObjectNode wcNode = om.createObjectNode();
        wcNode.put("worldName", this.elementName.getValue());
        wcNode.put("worldShouldPass", this.worldShouldPass);
        ArrayNode blocks = om.createArrayNode();
        for (Block block : this.getBlocks()) {
            blocks.add(block.toJson(om));
        }
        wcNode.set("blocks", blocks);
        return wcNode;
    }

    public WorldController(Controller<?> parent) {
        super(parent, new WorldControllerFactory(), "SubWorld");
        for (int i = 0; i < 8; ++i) {
            this.tiles.add(new ArrayList());
        }
        for (int row = 0; row < 8; ++row) {
            for (int column = 0; column < 8; ++column) {
                Tile newTile = new Tile();
                this.tiles.get(row).add(column, newTile);
            }
        }
    }

    public boolean makeBlock(BlockSize blockSize, BlockType blockType, int posX, int posY) {
        if (posX < 0 || posX >= 8 || posY < 0 || posY >= 8) {
            return false;
        }
        if (this.getTile(posX, posY).hasBlock()) {
            return false;
        }
        Block newBlock = new Block(blockSize, blockType, posX, posY);
        this.getTile(posX, posY).setBlock(newBlock);
        GlobalSettings.registerChange();
        return true;
    }

    public boolean moveBlock(int oldX, int oldY, int newX, int newY) {
        if (newX < 0 || newX >= 8 || newY < 0 || newY >= 8 || oldX == newX && oldY == newY) {
            return false;
        }
        if (!this.getTile(oldX, oldY).hasBlock() || this.getTile(newX, newY).hasBlock()) {
            return false;
        }
        Tile oldTile = this.getTile(oldX, oldY);
        this.getTile(newX, newY).setBlock(oldTile.getBlock());
        oldTile.removeBlock();
        this.getTile(newX, newY).getBlock().setGridPosX(newX);
        this.getTile(newX, newY).getBlock().setGridPosY(newY);
        GlobalSettings.registerChange();
        return true;
    }

    public boolean removeBlock(int posX, int posY) {
        if (!this.getTile(posX, posY).hasBlock()) {
            return false;
        }
        this.getTile(posX, posY).removeBlock();
        GlobalSettings.registerChange();
        return true;
    }

    private Tile getTile(int x, int y) {
        return this.tiles.get(x).get(y);
    }

    @JsonIgnore
    public ArrayList<ArrayList<Tile>> getGridTiles() {
        return this.tiles;
    }

    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ArrayList<Tile> colTiles : this.tiles) {
            for (Tile tile : colTiles) {
                if (!tile.hasBlock()) continue;
                blocks.add(tile.getBlock());
            }
        }
        return blocks;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.getBlocks().size() == 0;
    }

    public boolean setBlockName(int row, int column, String newName) {
        if (newName.length() > 1) {
            return false;
        }
        if (newName.length() == 0) {
            this.getTile(row, column).getBlock().setName(newName);
            GlobalSettings.registerChange();
            return true;
        }
        Scanner charScanner = new Scanner(newName);
        String result = charScanner.findInLine(this.validBlockNameRegex);
        charScanner.close();
        if (result == null) {
            return false;
        }
        for (Block block : this.getBlocks()) {
            if (block.getName() == null || !block.getName().equals(newName) || block.getGridPosX() == row && block.getGridPosY() == column) continue;
            return false;
        }
        this.getTile(row, column).getBlock().setName(newName);
        GlobalSettings.registerChange();
        return true;
    }

    public BlockPos getBlockWithNameCollision(int row, int column, String newName) {
        for (Block block : this.getBlocks()) {
            if (block.getName() == null || !block.getName().equals(newName) || block.getGridPosX() == row && block.getGridPosY() == column) continue;
            return new BlockPos(block.getGridPosX(), block.getGridPosY());
        }
        return null;
    }

    public void setBlocks(List<Block> list) {
        for (Block b : list) {
            Tile tile = this.getTile(b.getGridPosX(), b.getGridPosY());
            tile.setBlock(b);
        }
        GlobalSettings.registerChange();
    }

    public void setWorldShouldPass(Boolean worldShouldPass) {
        this.worldShouldPass = worldShouldPass;
        GlobalSettings.registerChange();
    }

    public Boolean getWorldShouldPass() {
        return this.worldShouldPass;
    }
}

