/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import tarski.core.controller.Controller;
import tarski.core.controller.EvaluationStatus;
import tarski.core.controller.WorldController;
import tarski.core.controller.factory.WorldControllerFactory;
import tarski.core.formula.EvalException;
import tarski.core.formula.Formula;
import tarski.core.parser.EvalResult;
import tarski.core.parser.FormulaParser;
import tarski.core.parser.ParseError;
import tarski.core.parser.TokenHighlight;
import tarski.gui.common.GlobalSettings;
import tarski.gui.common.Logger;

public final class QuestionController
extends Controller<WorldController> {
    private static final long serialVersionUID = 5940443586282383004L;
    private String question;
    private String formulaText = "";
    private transient Formula formulaObject;
    private FormulaParser formulaParser;
    private static final String DEFAULT_QUESTION = "Click to edit this question box.";

    public QuestionController(JsonNode jn, Controller<?> parent, FormulaParser parser) {
        super(parent, new WorldControllerFactory(), "World-");
        this.setName(jn.get("formulaName").asText());
        this.setParent(parent);
        this.question = jn.get("question").asText();
        this.formulaText = jn.get("formulaText").asText();
        ArrayNode worlds = (ArrayNode)jn.get("worlds");
        for (JsonNode worldNode : worlds) {
            this.elements.add(new WorldController(worldNode, this));
        }
        this.formulaParser = parser;
        this.parseFormula();
    }

    @Override
    public ObjectNode toJson(ObjectMapper om, Controller<?> parent) {
        ObjectNode qcNode = om.createObjectNode();
        qcNode.put("formulaName", this.elementName.getValue());
        qcNode.put("question", this.question);
        qcNode.put("formulaText", this.formulaText);
        ArrayNode elements = om.createArrayNode();
        for (WorldController controller : this.getElements()) {
            elements.add(controller.toJson(om, this));
        }
        qcNode.set("worlds", elements);
        return qcNode;
    }

    public QuestionController(Controller<?> parent, FormulaParser formulaParser) {
        super(parent, new WorldControllerFactory(), "World-");
        this.formulaParser = formulaParser;
        this.question = DEFAULT_QUESTION;
    }

    public EvalResult evalWorlds() {
        EvaluationStatus.startEvaluationMode(20);
        Boolean allSuccess = true;
        if (this.formulaObject != null) {
            for (WorldController world : this.getElements()) {
                EvalResult result = this.evalWorld(world);
                if (!result.equals((Object)EvalResult.ERROR) && !result.equals((Object)EvalResult.FAILED)) continue;
                allSuccess = false;
            }
            if (this.getElements().isEmpty()) {
                this.setEvalResult(EvalResult.UNEVALUATED);
                Logger.getLogger().evalLog(this.getName(), "Formula has no worlds to evaluate. Skipping evaluation.");
            } else if (allSuccess.booleanValue()) {
                this.setEvalResult(EvalResult.PASSED);
            } else {
                this.setEvalResult(EvalResult.FAILED);
            }
        } else {
            this.setEvalResult(EvalResult.ERROR);
            EvaluationStatus.sendMessageWithLock(20, this.getName(), "Invalid formula structure. Cannot evaluate the worlds.");
        }
        EvaluationStatus.stopEvaluationMode(20);
        return this.getEvalResult();
    }

    public EvalResult evalWorld(WorldController worldController) {
        block5: {
            EvaluationStatus.startEvaluationMode(30);
            this.parseFormula();
            if (this.formulaObject != null) {
                try {
                    if (this.formulaObject.eval(worldController) == worldController.getWorldShouldPass().booleanValue()) {
                        worldController.setEvalResult(EvalResult.PASSED);
                        break block5;
                    }
                    worldController.setEvalResult(EvalResult.FAILED);
                }
                catch (EvalException e) {
                    String source = this.getName() + " / " + worldController.getName();
                    Logger.getLogger().evalLog(source, e.getMessage());
                    worldController.setEvalResult(EvalResult.ERROR);
                }
            } else {
                this.setEvalResult(EvalResult.ERROR);
                worldController.setEvalResult(EvalResult.ERROR);
                EvaluationStatus.sendMessageWithLock(30, this.getName(), "Invalid formula structure. Cannot evaluate the world.");
            }
        }
        EvaluationStatus.stopEvaluationMode(30);
        return worldController.getEvalResult();
    }

    public void parseFormula() {
        this.formulaObject = this.formulaParser.parseFormula(this.formulaText);
    }

    public List<ParseError> getParseErrors() {
        return this.formulaParser.getParseErrors();
    }

    public List<TokenHighlight> getTokenHighlights() {
        return this.formulaParser.getTokenHighlights();
    }

    public boolean setQuestion(String text) {
        GlobalSettings.registerChange();
        this.question = text;
        return true;
    }

    public String getQuestion() {
        return this.question;
    }

    public boolean setFormulaText(String text) {
        GlobalSettings.registerChange();
        this.formulaText = text;
        return true;
    }

    public String getFormulaText() {
        return this.formulaText;
    }

    public boolean isValidFormula() {
        return this.formulaObject != null;
    }

    public Formula getFormula() {
        return this.formulaObject;
    }

    public String getFormattedText() {
        return this.formulaParser.getFormattedText();
    }
}

