/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import tarski.core.controller.Controller;
import tarski.core.controller.EvaluationStatus;
import tarski.core.controller.QuestionController;
import tarski.core.controller.WorldController;
import tarski.core.controller.factory.QuestionControllerFactory;
import tarski.core.parser.AntlrParser;
import tarski.core.parser.EvalResult;
import tarski.gui.common.GlobalSettings;
import tarski.gui.common.Logger;

public final class DataController
extends Controller<QuestionController> {
    private static final long serialVersionUID = -8818822452706411728L;

    public DataController() {
        super(null, new QuestionControllerFactory(), "Formula-");
    }

    public DataController(JsonNode jn, Controller<?> parent) {
        super(null, new QuestionControllerFactory(), "Formula-");
        ArrayNode formulas = (ArrayNode)jn.get("formulas");
        for (JsonNode formulaNode : formulas) {
            this.elements.add(new QuestionController(formulaNode, this, new AntlrParser()));
        }
    }

    @Override
    public ObjectNode toJson(ObjectMapper om, Controller<?> parent) {
        ObjectNode dcNode = om.createObjectNode();
        ArrayNode elements = om.createArrayNode();
        for (QuestionController controller : this.getElements()) {
            elements.add(controller.toJson(om, this));
        }
        dcNode.set("formulas", elements);
        return dcNode;
    }

    public void importTestWorldsFromFile(JsonNode testWorldsNode) {
        for (QuestionController formula : this.getElements()) {
            formula.getElements().clear();
        }
        ArrayNode formulas = (ArrayNode)testWorldsNode.get("formulas");
        for (JsonNode formulaNode : formulas) {
            QuestionController currentFormula = (QuestionController)this.getElementByName(formulaNode.get("formulaName").asText());
            if (currentFormula != null) {
                for (JsonNode world : (ArrayNode)formulaNode.get("worlds")) {
                    currentFormula.addElement(new WorldController(world, this));
                }
                continue;
            }
            this.addElement(new QuestionController(formulaNode, this, new AntlrParser()));
        }
    }

    public EvalResult evalAll() {
        EvaluationStatus.startEvaluationMode(10);
        Boolean allSuccess = true;
        for (QuestionController formula : this.getElements()) {
            EvalResult result = formula.evalWorlds();
            if (!result.equals((Object)EvalResult.ERROR) && !result.equals((Object)EvalResult.FAILED)) continue;
            allSuccess = false;
        }
        if (this.getElements().isEmpty()) {
            this.setEvalResult(EvalResult.UNEVALUATED);
            Logger.getLogger().evalLog(this.getName(), "No formulas to evaluate.");
        } else if (allSuccess.booleanValue()) {
            this.setEvalResult(EvalResult.PASSED);
        } else {
            this.setEvalResult(EvalResult.FAILED);
        }
        EvaluationStatus.stopEvaluationMode(10);
        return this.getEvalResult();
    }

    public void setQuestions(ArrayList<QuestionController> questions) {
        GlobalSettings.registerChange();
        this.setElements(questions);
    }
}

