/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import tarski.core.controller.factory.ControllerFactory;
import tarski.core.parser.EvalResult;
import tarski.gui.common.GlobalSettings;

public abstract class Controller<T extends Controller<?>>
implements Serializable {
    private static final long serialVersionUID = 8887011264506313334L;
    protected String defaultGenericTypeNamePrefix;
    protected ArrayList<T> elements;
    protected int elementNameCounter = 0;
    protected ControllerFactory<T> elementFactory;
    protected transient SimpleStringProperty elementName = new SimpleStringProperty("");
    protected transient ObjectProperty<Controller<?>> parent = new SimpleObjectProperty();
    protected transient ObjectProperty<EvalResult> evalResult = new SimpleObjectProperty<EvalResult>(EvalResult.UNEVALUATED);

    public Controller(JsonNode jn, Controller<?> parent) {
        this.elements = new ArrayList();
    }

    public Controller(Controller<?> parent, ControllerFactory<T> elementFactory, String defaultGenericTypeNamePrefix) {
        this.elements = new ArrayList();
        this.parent.setValue(parent);
        this.elementFactory = elementFactory;
        this.defaultGenericTypeNamePrefix = defaultGenericTypeNamePrefix;
    }

    public Controller<?> getParent() {
        return (Controller)this.parent.getValue();
    }

    public void setParent(Controller<?> newParent) {
        this.parent.setValue(newParent);
    }

    public ObjectProperty<Controller<?>> getParentProperty() {
        return this.parent;
    }

    public T createElement() {
        return this.createElement(this.generateElementName());
    }

    public T createElement(String elementName) {
        Controller element = (Controller)this.elementFactory.newInstance(this);
        if (!this.renameElement(element, elementName)) {
            element.setName(this.generateElementName());
        }
        this.elements.add(element);
        GlobalSettings.registerChange();
        return (T)element;
    }

    public Boolean addElement(T element) {
        if (this.elementNameIsUnique(((Controller)element).getName())) {
            this.elements.add(element);
            ((Controller)element).setParent(this);
            GlobalSettings.registerChange();
            return true;
        }
        return false;
    }

    public Boolean addElementAtIndex(T element, int index) {
        if (this.elementNameIsUnique(((Controller)element).getName())) {
            this.elements.add(index, element);
            GlobalSettings.registerChange();
            return true;
        }
        return false;
    }

    public Boolean addElementAndReplace(T element) {
        if (!this.elementNameIsUnique(((Controller)element).getName())) {
            T elementToReplace = this.getElementByName(((Controller)element).getName());
            this.elements.remove(elementToReplace);
        }
        this.addElement(element);
        GlobalSettings.registerChange();
        return true;
    }

    public void resetEvalResult() {
        this.setEvalResult(EvalResult.UNEVALUATED);
    }

    public List<T> getElements() {
        return this.elements;
    }

    public void setElements(ArrayList<T> elements) {
        this.elements = elements;
        GlobalSettings.registerChange();
    }

    public String getName() {
        return this.elementName.get();
    }

    public void setName(String elementName) {
        this.elementName.setValue(elementName);
        GlobalSettings.registerChange();
    }

    public StringProperty nameProperty() {
        return this.elementName;
    }

    public boolean removeElement(T element) {
        GlobalSettings.registerChange();
        return this.elements.remove(element);
    }

    public boolean renameElement(T element, String newElementName) {
        if (!this.elementNameIsUnique(newElementName)) {
            return false;
        }
        ((Controller)element).setName(newElementName);
        GlobalSettings.registerChange();
        return true;
    }

    public void setEvalResult(EvalResult evalResult) {
        this.evalResult.set(evalResult);
    }

    public ObjectProperty<EvalResult> evalResultProperty() {
        return this.evalResult;
    }

    public EvalResult getEvalResult() {
        return (EvalResult)((Object)this.evalResult.getValue());
    }

    public boolean elementNameIsUnique(String elementName) {
        for (Controller currentElement : this.elements) {
            if (!currentElement.getName().equals(elementName)) continue;
            return false;
        }
        return true;
    }

    public T getElementByName(String name) {
        for (Controller currentElement : this.elements) {
            if (!currentElement.getName().equals(name)) continue;
            return (T)currentElement;
        }
        return null;
    }

    private String generateElementName() {
        String currentName = this.defaultGenericTypeNamePrefix + this.elementNameCounter;
        while (!this.elementNameIsUnique(currentName)) {
            ++this.elementNameCounter;
            currentName = this.defaultGenericTypeNamePrefix + this.elementNameCounter;
        }
        return currentName;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(((EvalResult)((Object)this.evalResult.getValue())).ordinal());
        s.writeUTF(this.getName());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.evalResult = new SimpleObjectProperty<EvalResult>(EvalResult.values()[s.read()]);
        this.elementName = new SimpleStringProperty(s.readUTF());
        this.parent = new SimpleObjectProperty();
    }

    public abstract ObjectNode toJson(ObjectMapper var1, Controller<?> var2);
}

