/*
 * Decompiled with CFR 0.152.
 */
package tarski.core.block;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import tarski.core.block.BlockSize;
import tarski.core.block.BlockType;

@JsonPropertyOrder(value={"name", "blockSize", "blockType", "gridPosX", "gridPosY"})
public class Block
implements Serializable {
    private static final long serialVersionUID = -5972198464038038946L;
    private BlockSize blockSize;
    private BlockType blockType;
    private String name = "";
    private int gridPosX;
    private int gridPosY;

    public Block(JsonNode jn) {
        this.name = jn.get("name").asText();
        this.gridPosX = jn.get("gridPosX").asInt();
        this.gridPosY = jn.get("gridPosY").asInt();
        this.blockSize = BlockSize.valueOf(jn.get("blockSize").asText());
        this.blockType = BlockType.valueOf(jn.get("blockType").asText());
    }

    public ObjectNode toJson(ObjectMapper om) {
        ObjectNode bNode = om.createObjectNode();
        bNode.put("name", this.name);
        bNode.put("gridPosX", this.gridPosX);
        bNode.put("gridPosY", this.gridPosY);
        bNode.put("blockSize", this.blockSize.toString());
        bNode.put("blockType", this.blockType.toString());
        return bNode;
    }

    public Block(BlockSize blockSize, BlockType blockType, int gridPosX, int gridPosY) {
        this.blockSize = blockSize;
        this.blockType = blockType;
        this.gridPosX = gridPosX;
        this.gridPosY = gridPosY;
    }

    public Block(String name, BlockSize blockSize, BlockType blockType, int gridPosX, int gridPosY) {
        this(blockSize, blockType, gridPosX, gridPosY);
        this.name = name;
    }

    public Block() {
    }

    public int getGridPosX() {
        return this.gridPosX;
    }

    public void setGridPosX(int gridPosX) {
        this.gridPosX = gridPosX;
    }

    public int getGridPosY() {
        return this.gridPosY;
    }

    public void setGridPosY(int gridPosY) {
        this.gridPosY = gridPosY;
    }

    public BlockSize getBlockSize() {
        return this.blockSize;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public int getNameIndex() {
        return this.name.charAt(0) - 97;
    }

    @JsonIgnore
    public boolean hasName() {
        return this.name != null && !this.name.equals("");
    }

    @JsonIgnore
    public boolean isTriangle() {
        return this.blockType == BlockType.TRIANGLE;
    }

    @JsonIgnore
    public boolean isSquare() {
        return this.blockType == BlockType.SQUARE;
    }

    @JsonIgnore
    public boolean isPentagon() {
        return this.blockType == BlockType.PENTAGON;
    }

    @JsonIgnore
    public boolean isSmall() {
        return this.blockSize == BlockSize.SMALL;
    }

    @JsonIgnore
    public boolean isMedium() {
        return this.blockSize == BlockSize.MEDIUM;
    }

    @JsonIgnore
    public boolean isLarge() {
        return this.blockSize == BlockSize.LARGE;
    }

    @JsonIgnore
    public boolean smaller(Block b) {
        return this.blockSize.ordinal() < b.blockSize.ordinal();
    }

    @JsonIgnore
    public boolean sameSize(Block b) {
        return this.blockSize == b.blockSize;
    }

    @JsonIgnore
    public boolean sameCol(Block b) {
        return this.gridPosX == b.gridPosX;
    }

    @JsonIgnore
    public boolean sameRow(Block b) {
        return this.gridPosY == b.gridPosY;
    }

    @JsonIgnore
    public boolean leftOf(Block b) {
        return this.gridPosX < b.gridPosX;
    }

    private static int absolute(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public boolean between(Block b1, Block b2) {
        if (b1.gridPosY == b2.gridPosY) {
            return this.gridPosY == b1.gridPosY && (b1.gridPosX < this.gridPosX && this.gridPosX < b2.gridPosX || b2.gridPosX < this.gridPosX && this.gridPosX < b1.gridPosX);
        }
        if (b1.gridPosX == b2.gridPosX) {
            return this.gridPosX == b1.gridPosX && (b1.gridPosY < this.gridPosY && this.gridPosY < b2.gridPosY || b2.gridPosY < this.gridPosY && this.gridPosY < b1.gridPosY);
        }
        if (Block.absolute(b2.gridPosX - b1.gridPosX) == Block.absolute(b2.gridPosY - b1.gridPosY)) {
            return Block.absolute(this.gridPosX - b1.gridPosX) == Block.absolute(this.gridPosY - b1.gridPosY) && Block.absolute(this.gridPosX - b2.gridPosX) == Block.absolute(this.gridPosY - b2.gridPosY) && (b1.gridPosY < this.gridPosY && this.gridPosY < b2.gridPosY || b2.gridPosY < this.gridPosY && this.gridPosY < b1.gridPosY);
        }
        return false;
    }

    public void setBlockSize(BlockSize blockSize) {
        this.blockSize = blockSize;
    }

    public void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }
}

