/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.reactfx.value.FlatMapped;
import org.reactfx.value.Var;

class FlatMappedVar<T, U, O extends Property<U>>
extends FlatMapped<T, U, O>
implements Var<U> {
    private final ChangeListener<O> srcListenerWhenBound = (obs, oldProperty, newProperty) -> {
        assert (this.boundTo != null);
        if (oldProperty != null) {
            oldProperty.unbind();
            onUnbind.accept(oldProperty);
        }
        if (newProperty != null) {
            newProperty.bind(this.boundTo);
        }
    };
    private ObservableValue<? extends U> boundTo = null;

    public FlatMappedVar(ObservableValue<T> src, Function<? super T, O> f, U resetToOnUnbind) {
        this(src, f, oldProperty -> oldProperty.setValue(resetToOnUnbind));
    }

    public FlatMappedVar(ObservableValue<T> src, Function<? super T, O> f) {
        this(src, f, oldProperty -> {});
    }

    private FlatMappedVar(ObservableValue<T> src, Function<? super T, O> f, Consumer<O> onUnbind) {
        super(src, f);
    }

    @Override
    public void setValue(U value) {
        this.src.ifPresent(sel -> {
            sel.setValue(value);
            this.invalidate();
        });
    }

    @Override
    public void bind(ObservableValue<? extends U> other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot bind to null");
        }
        if (this.boundTo == null) {
            this.src.addListener(this.srcListenerWhenBound);
        }
        this.src.ifPresent(sel -> sel.bind(other));
        this.boundTo = other;
    }

    @Override
    public void unbind() {
        if (this.boundTo != null) {
            this.src.removeListener(this.srcListenerWhenBound);
            this.src.ifPresent(Property::unbind);
            this.boundTo = null;
        }
    }

    @Override
    public boolean isBound() {
        return this.boundTo != null || this.src.isPresent() && ((Property)this.src.getOrThrow()).isBound();
    }
}

