/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.PaintConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.javafx.Icon;
import org.kordamp.ikonli.javafx.IkonResolver;

public class StackedFontIcon
extends StackPane
implements Icon {
    private static final String KEY_STACKED_FONT_ICON_SIZE = StackedFontIcon.class.getName() + ".iconSize";
    private StyleableIntegerProperty iconSize;
    private StyleableObjectProperty<Paint> iconColor;
    private double[] iconSizes = new double[0];
    private ChangeListener<Number> iconSizeChangeListener = (v, o, n) -> this.setIconSizeOnChildren(n.intValue());
    private ChangeListener<Paint> iconColorChangeListener = (v, o, n) -> this.setIconColorOnChildren((Paint)n);

    public static void setIconSize(Node icon, double size) {
        if (icon != null && size >= 0.0 && size <= 1.0) {
            icon.getProperties().put(KEY_STACKED_FONT_ICON_SIZE, size);
        }
    }

    public static double getIconSize(Node icon) {
        Object value;
        if (icon != null && (value = icon.getProperties().get(KEY_STACKED_FONT_ICON_SIZE)) instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 1.0;
    }

    public StackedFontIcon() {
        this.getStyleClass().setAll((String[])new String[]{"stacked-ikonli-font-icon"});
        final String propertiesListenerKey = StackedFontIcon.class.getName() + "-" + System.identityHashCode(this);
        this.getChildren().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        int size = c.getTo() - c.getFrom();
                        StackedFontIcon.this.iconSizes = Arrays.copyOf(StackedFontIcon.this.iconSizes, StackedFontIcon.this.iconSizes.length + size);
                        for (int i = c.getFrom(); i < c.getTo(); ++i) {
                            StackedFontIcon.this.iconSizes[i] = StackedFontIcon.getIconSize((Node)c.getList().get(i));
                        }
                        for (Node node : c.getAddedSubList()) {
                            node.getProperties().put(propertiesListenerKey, new NodeSizeListener(node));
                        }
                        continue;
                    }
                    if (c.wasRemoved()) {
                        int i;
                        int size = c.getTo() - c.getFrom();
                        double[] newIconSizes = new double[StackedFontIcon.this.iconSizes.length - size];
                        boolean bl = false;
                        for (i = 0; i < c.getFrom(); ++i) {
                            newIconSizes[++var4_11] = StackedFontIcon.this.iconSizes[i];
                        }
                        for (i = c.getTo(); i < StackedFontIcon.this.iconSizes.length; ++i) {
                            newIconSizes[++var4_12] = StackedFontIcon.this.iconSizes[i];
                        }
                        StackedFontIcon.this.iconSizes = newIconSizes;
                        for (Node node : c.getRemoved()) {
                            node.getProperties().remove(propertiesListenerKey);
                        }
                        continue;
                    }
                    if (!c.wasPermutated()) continue;
                    double[] newIconSizes = Arrays.copyOf(StackedFontIcon.this.iconSizes, StackedFontIcon.this.iconSizes.length);
                    for (int i = c.getFrom(); i <= c.getTo(); ++i) {
                        newIconSizes[i] = c.getPermutation(i);
                    }
                    StackedFontIcon.this.iconSizes = newIconSizes;
                }
            }
        });
    }

    @Override
    public IntegerProperty iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableIntegerProperty(16){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_SIZE;
                }

                @Override
                public Object getBean() {
                    return StackedFontIcon.this;
                }

                @Override
                public String getName() {
                    return "iconSize";
                }
            };
            this.iconSize.addListener((ChangeListener<? super Number>)this.iconSizeChangeListener);
        }
        return this.iconSize;
    }

    @Override
    public ObjectProperty<Paint> iconColorProperty() {
        if (this.iconColor == null) {
            this.iconColor = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.ICON_COLOR;
                }

                @Override
                public Object getBean() {
                    return StackedFontIcon.this;
                }

                @Override
                public String getName() {
                    return "iconColor";
                }
            };
            this.iconColor.addListener(this.iconColorChangeListener);
        }
        return this.iconColor;
    }

    @Override
    public void setIconSize(int size) {
        if (size <= 0) {
            throw new IllegalStateException("Argument 'size' must be greater than zero.");
        }
        this.iconSizeProperty().set(size);
    }

    @Override
    public int getIconSize() {
        return this.iconSizeProperty().get();
    }

    @Override
    public void setIconColor(Paint paint) {
        Objects.requireNonNull(paint, "Argument 'paint' must not be null");
        this.iconColorProperty().set(paint);
    }

    @Override
    public Paint getIconColor() {
        return (Paint)this.iconColorProperty().get();
    }

    public void setIconCodes(Ikon ... iconCodes) {
        this.getChildren().clear();
        this.initializeSizesIfNeeded(iconCodes);
        this.updateIconCodes(iconCodes);
    }

    public void setIconCodeLiterals(String ... iconCodes) {
        this.getChildren().clear();
        Ikon[] codes = new Ikon[iconCodes.length];
        for (int i = 0; i < iconCodes.length; ++i) {
            codes[i] = IkonResolver.getInstance().resolveIkonHandler(iconCodes[i]).resolve(iconCodes[i]);
        }
        this.initializeSizesIfNeeded(iconCodes);
        this.updateIconCodes(codes);
    }

    public void setIconSizes(double ... iconSizes) {
        this.iconSizes = iconSizes;
        this.setIconSizeOnChildren(this.getIconSize());
    }

    public void setColors(Paint ... iconColors) {
        int i = 0;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            ((Icon)((Object)node)).setIconColor(iconColors[i++]);
        }
    }

    private void initializeSizesIfNeeded(Object[] array) {
        if (this.iconSizes.length == 0 || this.iconSizes.length != array.length) {
            this.iconSizes = new double[array.length];
            Arrays.fill(this.iconSizes, 1.0);
        }
    }

    private void updateIconCodes(Ikon[] iconCodes) {
        for (int index = 0; index < iconCodes.length; ++index) {
            this.getChildren().add(this.createFontIcon(iconCodes[index], index));
        }
    }

    private FontIcon createFontIcon(Ikon iconCode, int index) {
        FontIcon icon = new FontIcon(iconCode);
        icon.setIconSize(this.getIconSize());
        icon.setIconColor(this.getIconColor());
        int size = icon.getIconSize();
        this.applySizeToIcon(size, icon, index);
        return icon;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedFontIcon.getClassCssMetaData();
    }

    private void setIconSizeOnChildren(int size) {
        int i = 0;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            this.applySizeToIcon(size, (Icon)((Object)node), i++);
        }
    }

    private void applySizeToIcon(int size, Icon icon, int index) {
        double childPercentageSize = this.iconSizes[index];
        double newSize = (double)size * childPercentageSize;
        icon.setIconSize((int)newSize);
    }

    private void setIconColorOnChildren(Paint color) {
        for (Node node : this.getChildren()) {
            if (!(node instanceof Icon)) continue;
            ((Icon)((Object)node)).setIconColor(color);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedFontIcon, Number> ICON_SIZE = new CssMetaData<StackedFontIcon, Number>("-fx-icon-size", SizeConverter.getInstance(), (Number)16.0){

            @Override
            public boolean isSettable(StackedFontIcon fontIcon) {
                return true;
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(StackedFontIcon icon) {
                return (StyleableProperty)((Object)icon.iconSizeProperty());
            }
        };
        private static final CssMetaData<StackedFontIcon, Paint> ICON_COLOR = new CssMetaData<StackedFontIcon, Paint>("-fx-icon-color", PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(StackedFontIcon node) {
                return true;
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(StackedFontIcon icon) {
                return (StyleableProperty)((Object)icon.iconColorProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(StackPane.getClassCssMetaData());
            styleables.add(ICON_SIZE);
            styleables.add(ICON_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private class NodeSizeListener
    implements MapChangeListener<Object, Object> {
        private Node node;

        private NodeSizeListener(Node node) {
            this.node = node;
        }

        @Override
        public void onChanged(MapChangeListener.Change<?, ?> change) {
            if (KEY_STACKED_FONT_ICON_SIZE.equals(String.valueOf(change.getKey()))) {
                int size = StackedFontIcon.this.getChildren().size();
                for (int i = 0; i < size; ++i) {
                    if (this.node != StackedFontIcon.this.getChildren().get(i)) continue;
                    double value = 0.0;
                    Object valueAdded = change.getValueAdded();
                    value = valueAdded instanceof Number ? ((Number)valueAdded).doubleValue() : Double.parseDouble(String.valueOf(valueAdded));
                    StackedFontIcon.this.iconSizes[i] = value;
                    return;
                }
            }
        }
    }
}

